/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.LSPTaskQueue;
import org.flasck.flas.compiler.TaskQueue;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lsp.FLASLanguageClient;
import org.flasck.flas.lsp.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSPCore {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private final ErrorReporter errors;
    private final File flasHome;
    private final TaskQueue taskQ;
    private final Map<String, Root> roots = new TreeMap<String, Root>();
    private String cardsFolder;
    private boolean readyToNotify;

    public LSPCore(ErrorReporter errors, File flasHome) {
        this.errors = errors;
        this.flasHome = flasHome;
        this.taskQ = new LSPTaskQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoot(FLASLanguageClient client, String rootUri) {
        logger.info("opening root " + rootUri);
        try {
            Map<String, Root> map = this.roots;
            synchronized (map) {
                URI uri = new URI(rootUri + "/");
                Root root = new Root(client, this.errors, this.taskQ, uri);
                if (this.roots.containsKey(root.root.getPath())) {
                    return;
                }
                this.errors.logMessage("opening root " + root.root);
                this.roots.put(root.root.getPath(), root);
                root.configure(this.flasHome);
                root.setCardsFolder(this.cardsFolder);
            }
        }
        catch (URISyntaxException ex) {
            this.errors.logMessage("could not open " + rootUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doParsing(boolean readyForNotifications) {
        this.readyToNotify |= readyForNotifications;
        if (!this.readyToNotify) {
            return;
        }
        Map<String, Root> map = this.roots;
        synchronized (map) {
            for (Root root : this.roots.values()) {
                root.gatherFiles();
                root.compileAll();
            }
        }
    }

    public void dispatch(URI uri, String text) {
        if (!this.readyToNotify) {
            return;
        }
        Root r = this.findRoot(uri);
        r.dispatch(uri, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Root findRoot(URI uri) {
        Map<String, Root> map = this.roots;
        synchronized (map) {
            String path = uri.getPath();
            for (Map.Entry<String, Root> e : this.roots.entrySet()) {
                if (!path.startsWith(e.getKey())) continue;
                return e.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCardsFolder(String cardsFolder) {
        logger.info("setting cards folder to " + cardsFolder);
        this.cardsFolder = cardsFolder;
        Map<String, Root> map = this.roots;
        synchronized (map) {
            for (Root r : this.roots.values()) {
                r.setCardsFolder(cardsFolder);
            }
        }
    }

    public ErrorReporter errors() {
        return this.errors;
    }
}

