/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.flasck.flas.lsp.LSPCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLASWorkspaceService
implements WorkspaceService {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private final LSPCore core;

    public FLASWorkspaceService(LSPCore core) {
        this.core = core;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        JsonObject settings = (JsonObject)params.getSettings();
        String cardsFolder = settings.get("FLAS").getAsJsonObject().get("lookForCardsInFolder").getAsString();
        this.core.setCardsFolder(cardsFolder);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        logger.info("CHANGE WATCHED FILES");
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        switch (params.getCommand()) {
            case "flas/readyForNotifications": {
                logger.info("received command readyForNotifications");
                this.core.doParsing(true);
                return CompletableFuture.completedFuture(null);
            }
        }
        logger.error("cannot handle command " + params.getCommand());
        return CompletableFuture.completedFuture(null);
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        logger.info("CHANGE WATCHED FOLDERS");
        super.didChangeWorkspaceFolders(params);
    }
}

