/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.flasck.flas.lsp.FLASFileWatchingService;
import org.flasck.flas.lsp.FLASLanguageClient;
import org.flasck.flas.lsp.FLASWorkspaceService;
import org.flasck.flas.lsp.LSPCore;
import org.flasck.flas.lsp.LSPErrorForwarder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLASLanguageServer
implements LanguageServer {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private final FLASFileWatchingService watchingService;
    private final LSPCore core;
    private FLASLanguageClient client;
    private LSPErrorForwarder errors = new LSPErrorForwarder();

    public FLASLanguageServer(File flasHome) {
        this.core = new LSPCore(this.errors, flasHome);
        this.watchingService = new FLASFileWatchingService(this.core.errors(), this.core);
    }

    public void provide(FLASLanguageClient client) {
        this.client = client;
        this.errors.connect(client);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        logger.info("initialize");
        List folders = params.getWorkspaceFolders();
        if (folders != null) {
            for (WorkspaceFolder f : folders) {
                this.core.addRoot(this.client, f.getUri());
            }
        }
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
        return CompletableFuture.completedFuture(new InitializeResult(capabilities));
    }

    public TextDocumentService getTextDocumentService() {
        return this.watchingService;
    }

    public WorkspaceService getWorkspaceService() {
        return new FLASWorkspaceService(this.core);
    }

    public CompletableFuture<Object> shutdown() {
        logger.info("SHUTDOWN");
        return CompletableFuture.completedFuture(null);
    }

    public void exit() {
        logger.info("EXIT");
    }
}

