/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lsp.LSPCore;
import org.flasck.flas.lsp.WorkspaceFileNameComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.utils.FileUtils;

public class FLASFileWatchingService
implements TextDocumentService {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private final LSPCore dispatcher;
    private final ErrorReporter errors;

    public FLASFileWatchingService(ErrorReporter errors, LSPCore dispatcher) {
        this.errors = errors;
        this.dispatcher = dispatcher;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        URI uri = this.parseURI(params.getTextDocument().getUri());
        if (uri == null) {
            logger.warn("no uri specified");
            return;
        }
        String text = params.getTextDocument().getText();
        logger.info("saw open of " + uri);
        this.dispatcher.dispatch(uri, text);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        URI uri = this.parseURI(params.getTextDocument().getUri());
        if (uri == null) {
            logger.warn("no uri specified");
            return;
        }
        logger.info("saw change to " + uri);
        if (!WorkspaceFileNameComparator.isValidExtension(FileUtils.extension((String)uri.getPath()))) {
            return;
        }
        for (TextDocumentContentChangeEvent changeEvent : params.getContentChanges()) {
            if (changeEvent.getRange() != null) {
                throw new UnsupportedOperationException("Range should be null for full document update.");
            }
            if (changeEvent.getText() == null) {
                throw new UnsupportedOperationException("Text should not be null.");
            }
            this.dispatcher.dispatch(uri, changeEvent.getText());
        }
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void didClose(DidCloseTextDocumentParams params) {
        System.out.println("CLOSE");
    }

    private URI parseURI(String uris) {
        try {
            return new URI(uris);
        }
        catch (URISyntaxException ex) {
            this.errors.logMessage("Problem parsing " + uris);
            return null;
        }
    }
}

