/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import java.net.URI;
import org.flasck.flas.compiler.CompileUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileTask
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger((String)"Compiler");
    private final CompileUnit compiler;
    private final URI uri;
    private final String text;

    public CompileTask(CompileUnit compiler, URI uri, String text) {
        this.compiler = compiler;
        this.uri = uri;
        this.text = text;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CompileTask && this.uri.equals(((CompileTask)obj).uri);
    }

    @Override
    public void run() {
        try {
            this.compiler.parse(this.uri, this.text);
        }
        catch (Throwable t) {
            logger.error("Exception processing " + this.uri, t);
        }
    }

    public String toString() {
        return "CompileTask[" + this.uri + "]";
    }
}

