/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lifting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.HandlerName;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.lifting.FunctionGroupOrdering;
import org.flasck.flas.lifting.HLRewriter;
import org.flasck.flas.lifting.Lifter;
import org.flasck.flas.lifting.LiftingDependencyMapper;
import org.flasck.flas.lifting.MappingAnalyzer;
import org.flasck.flas.lifting.MappingStore;
import org.flasck.flas.lifting.NestedVarReader;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.TupleAssignment;
import org.flasck.flas.parsedForm.TupleMember;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.repository.FunctionGroup;
import org.flasck.flas.repository.FunctionGroups;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.RepositoryExtractor;
import org.flasck.flas.repository.Traverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.collections.ListMap;
import org.zinutils.collections.SetMap;
import org.zinutils.exceptions.CantHappenException;

public class RepositoryLifter
extends LeafAdapter
implements Lifter {
    public static final Logger logger = LoggerFactory.getLogger((String)"Lifter");
    private LiftingDependencyMapper dependencies = new LiftingDependencyMapper();
    private MappingStore ms;
    private MappingAnalyzer ma;
    private Set<LogicHolder> dull = new TreeSet<LogicHolder>();
    private Set<LogicHolder> interesting = new TreeSet<LogicHolder>();
    private List<FunctionGroup> ordering;
    private ListMap<HandlerName, LogicHolder> his = new ListMap();

    @Override
    public FunctionGroups lift(Repository r) {
        r.traverse(this);
        logger.info("dull:");
        for (LogicHolder lh : this.dull) {
            logger.info("  " + lh.name());
        }
        logger.info("interesting:");
        for (LogicHolder lh : this.interesting) {
            logger.info("  " + lh.name() + " => " + lh.nestedVars().vars());
            logger.info("    depends on " + lh.nestedVars().references() + " " + lh.nestedVars().referencesHI());
        }
        this.enhanceAll();
        this.refhandlers();
        this.resolve(RepositoryExtractor.nongenFunctions(r));
        logger.info("group ordering = " + this.ordering);
        int k = 0;
        for (FunctionGroup grp : this.ordering) {
            logger.info("Group #" + k++ + ": " + grp.size());
            for (LogicHolder lh : grp.functions()) {
                logger.info("  " + lh.name() + (String)(lh.nestedVars() != null ? " => " + lh.nestedVars().vars() : ""));
            }
        }
        return new FunctionGroupOrdering(this.ordering);
    }

    @Override
    public void visitHandlerImplements(HandlerImplements hi) {
        logger.info("saw HI " + hi);
        this.his.ensure((Object)hi.handlerName);
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        this.dependencies.recordFunction(fn);
        this.ms = new MappingStore(fn.name());
        this.ma = new MappingAnalyzer(fn, this.ms, this.dependencies);
    }

    @Override
    public void visitStandaloneMethod(StandaloneMethod meth) {
    }

    @Override
    public void visitTuple(TupleAssignment ta) {
        this.dependencies.recordFunction(ta);
        this.ms = new MappingStore(ta.name());
        this.ma = new MappingAnalyzer(ta, this.ms, this.dependencies);
    }

    @Override
    public void visitObjectMethod(ObjectMethod meth) {
        if (meth.name().container() instanceof HandlerName) {
            this.his.add((Object)((HandlerName)meth.name().container()), (Object)meth);
        }
        this.dependencies.recordFunction(meth);
        this.ms = new MappingStore(meth.name());
        this.ma = new MappingAnalyzer(meth, this.ms, this.dependencies);
        if (this.ma != null) {
            this.ma.visitObjectMethod(meth);
        }
    }

    @Override
    public void visitObjectCtor(ObjectCtor meth) {
        this.dependencies.recordFunction(meth);
        this.ms = new MappingStore(meth.name());
        this.ma = new MappingAnalyzer(meth, this.ms, this.dependencies);
        if (this.ma != null) {
            this.ma.visitObjectMethod(meth);
        }
    }

    @Override
    public void visitFunctionIntro(FunctionIntro fi) {
        this.ma.visitFunctionIntro(fi);
    }

    @Override
    public void visitTypeReference(TypeReference tr, boolean expectPolys, int nargs) {
        if (this.ma != null) {
            this.ma.visitTypeReference(tr);
        }
    }

    @Override
    public void visitUnresolvedVar(UnresolvedVar vr, int nargs) {
        if (this.ma != null) {
            this.ma.visitUnresolvedVar(vr);
        }
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (this.ma != null) {
            this.ma.visitDefn(expr.defn());
        }
        return expr.boundEarly();
    }

    @Override
    public void leaveFunction(FunctionDefinition fn) {
        if (this.ms.isInteresting()) {
            fn.nestedVars(this.ms);
            this.interesting.add(fn);
        } else {
            this.dull.add(fn);
        }
        if (!fn.isObjAccessor()) {
            fn.reportHolderInArgCount();
        }
        this.ma = null;
        this.ms = null;
    }

    @Override
    public void leaveObjectMethod(ObjectMethod meth) {
        if (this.ms.isInteresting()) {
            meth.nestedVars(this.ms);
            this.interesting.add(meth);
        } else {
            this.dull.add(meth);
        }
        this.ma = null;
        this.ms = null;
    }

    @Override
    public void leaveObjectCtor(ObjectCtor meth) {
        if (this.ms.isInteresting()) {
            meth.nestedVars(this.ms);
            this.interesting.add(meth);
        } else {
            this.dull.add(meth);
        }
        this.ma = null;
        this.ms = null;
    }

    @Override
    public void leaveStandaloneMethod(StandaloneMethod meth) {
        meth.reportHolderInArgCount();
    }

    @Override
    public void leaveTuple(TupleAssignment ta) {
        if (this.ms.isInteresting()) {
            ta.nestedVars(this.ms);
            this.interesting.add(ta);
        } else {
            this.dull.add(ta);
        }
        for (TupleMember tm : ta.members) {
            MappingStore msm = new MappingStore(ta.name());
            msm.recordDependency(ta);
            tm.nestedVars(msm);
            this.interesting.add(tm);
        }
        this.ma = null;
        this.ms = null;
    }

    public void enhanceAll() {
        boolean hasMore = true;
        while (hasMore) {
            hasMore = false;
            for (LogicHolder f : this.interesting) {
                hasMore |= this.enhance(f);
            }
        }
    }

    public void refhandlers() {
        for (LogicHolder f : this.interesting) {
            for (HandlerImplements hi : f.nestedVars().referencesHI()) {
                TreeMap<String, Pattern> scoped = new TreeMap<String, Pattern>();
                SetMap users = new SetMap();
                logger.info(f.name() + " depends on " + hi.handlerName);
                for (LogicHolder m : this.his.get((Object)hi.handlerName)) {
                    logger.info("  " + f.name() + " therefore depends on " + m.name());
                    f.nestedVars().dependsOn(m);
                    if (m.nestedVars() == null) continue;
                    m.nestedVars().dependsOn(f);
                    for (Pattern p : m.nestedVars().patterns()) {
                        if (p instanceof TypedPattern) {
                            TypedPattern tp = (TypedPattern)p;
                            scoped.put(tp.var.uniqueName(), tp);
                            users.add((Object)tp.var.uniqueName(), (Object)m.name());
                            continue;
                        }
                        if (p instanceof VarPattern) {
                            VarPattern vp = (VarPattern)p;
                            scoped.put(vp.name().uniqueName(), vp);
                            users.add((Object)vp.name().uniqueName(), (Object)m.name());
                            continue;
                        }
                        throw new CantHappenException("cannot handle pattern " + p + " as nested var");
                    }
                    m.nestedVars().clearPatterns();
                }
                int pos = 0;
                for (Map.Entry q : scoped.entrySet()) {
                    Pattern p;
                    p = (Pattern)q.getValue();
                    HandlerLambda hl = new HandlerLambda(p, true);
                    for (FunctionName n : users.get((Object)((String)q.getKey()))) {
                        hl.usedBy(n);
                    }
                    hi.boundVars.add(pos++, hl);
                    Traverser trav = new Traverser(new HLRewriter(p, hl)).withImplementedMethods();
                    trav.visitHandlerImplements(hi);
                }
            }
        }
    }

    public FunctionGroupOrdering resolve(Set<LogicHolder> processedFns) {
        this.ordering = new ArrayList<FunctionGroup>();
        for (LogicHolder f : this.dull) {
            this.ordering.add(new DependencyGroup(f));
        }
        processedFns.addAll(this.dull);
        TreeSet<LogicHolder> remainingFns = new TreeSet<LogicHolder>(this.interesting);
        while (!remainingFns.isEmpty()) {
            logger.debug("resolving " + remainingFns);
            boolean handled = false;
            HashSet<LogicHolder> done = new HashSet<LogicHolder>();
            for (LogicHolder logicHolder : remainingFns) {
                NestedVarReader nv = logicHolder.nestedVars();
                if (nv.containsReferencesNotIn(processedFns)) {
                    logger.debug("cannot handle " + logicHolder + " because it has " + nv.references());
                    continue;
                }
                logger.debug("extracted " + logicHolder + " as a candidate group");
                this.process(logicHolder, processedFns);
                done.add(logicHolder);
                this.ordering.add(new DependencyGroup(logicHolder));
                handled = true;
            }
            logger.debug("removing " + done + " from " + remainingFns);
            remainingFns.removeAll(done);
            if (handled) continue;
            TreeSet<LiftingGroup> options = new TreeSet<LiftingGroup>();
            for (LogicHolder fn3 : remainingFns) {
                Set<LogicHolder> tc = this.buildTransitiveClosure(fn3, processedFns);
                if (tc == null) continue;
                options.add(new LiftingGroup(tc));
            }
            logger.debug("failed to make progress in resolution, so trying to find an option from " + options);
            if (!options.isEmpty()) {
                LiftingGroup liftingGroup = (LiftingGroup)options.iterator().next();
                for (LogicHolder fn4 : liftingGroup.members) {
                    this.process(fn4, processedFns);
                }
                remainingFns.removeAll(liftingGroup.members);
                this.ordering.add(new DependencyGroup(liftingGroup.members));
                continue;
            }
            throw new RuntimeException("Failed to make progress: " + remainingFns + " -- " + processedFns);
        }
        return new FunctionGroupOrdering(this.ordering);
    }

    private boolean enhance(LogicHolder f) {
        boolean more = false;
        NestedVarReader nv = f.nestedVars();
        for (LogicHolder r : nv.references()) {
            more |= nv.enhanceWith(f, r.nestedVars());
        }
        return more;
    }

    private void process(LogicHolder fn, Set<LogicHolder> processedFns) {
        processedFns.add(fn);
    }

    private Set<LogicHolder> buildTransitiveClosure(LogicHolder fn, Set<LogicHolder> resolved) {
        TreeSet<LogicHolder> closure = new TreeSet<LogicHolder>();
        this.buildMaximalTransitiveClosure(fn, resolved, closure);
        logger.info("built maximal transitive closure " + closure);
        for (LogicHolder f : closure) {
            if (this.checkFn(f, closure)) continue;
            return null;
        }
        return closure;
    }

    private boolean checkFn(LogicHolder f, Set<LogicHolder> closure) {
        logger.debug("checking if " + f + " is integral to " + closure);
        Iterator<LogicHolder> iterator = closure.iterator();
        while (iterator.hasNext()) {
            NestedVarReader nv;
            LogicHolder g;
            logger.debug("  for " + g + " nv = " + nv + (String)((nv = (g = iterator.next()).nestedVars()) != null ? " " + nv.references() + " and " + nv.dependsOn(f) : ""));
            if (nv == null || !nv.dependsOn(f)) continue;
            return true;
        }
        logger.info("rejecting " + closure + " because none of them depend on " + f);
        return false;
    }

    private void buildMaximalTransitiveClosure(LogicHolder fn, Set<LogicHolder> resolved, Set<LogicHolder> closure) {
        if (closure.contains(fn)) {
            return;
        }
        closure.add(fn);
        NestedVarReader nv = fn.nestedVars();
        if (nv != null) {
            TreeSet<LogicHolder> added = new TreeSet<LogicHolder>(nv.references());
            added.addAll(nv.referencesHIMethods());
            added.removeAll(resolved);
            added.removeAll(closure);
            for (LogicHolder o : added) {
                this.buildMaximalTransitiveClosure(o, resolved, closure);
            }
        }
    }

    public class LiftingGroup
    implements Comparable<LiftingGroup> {
        private final Set<LogicHolder> members = new TreeSet<LogicHolder>();
        private final String leader;

        public LiftingGroup(Set<LogicHolder> members) {
            this.members.addAll(members);
            this.leader = this.members.iterator().next().name().uniqueName();
        }

        @Override
        public int compareTo(LiftingGroup o) {
            int ret = Integer.compare(this.members.size(), o.members.size());
            if (ret != 0) {
                return ret;
            }
            return this.leader.compareTo(o.leader);
        }

        public String toString() {
            return "Group" + this.members;
        }
    }
}

