/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lifting;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.lifting.MappingCollector;
import org.flasck.flas.lifting.NestedVarReader;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.patterns.HSIOptions;
import org.flasck.flas.patterns.HSIPatternOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.exceptions.NotImplementedException;

public class MappingStore
implements MappingCollector,
NestedVarReader {
    public static final Logger logger = LoggerFactory.getLogger((String)"Lifter");
    private final FunctionName name;
    private TreeSet<PO> patterns = new TreeSet();
    private Set<LogicHolder> deps = new HashSet<LogicHolder>();
    private Set<HandlerImplements> hideps = new HashSet<HandlerImplements>();

    public MappingStore(FunctionName name) {
        logger.info("Checking dependencies for " + name.uniqueName());
        this.name = name;
    }

    @Override
    public void recordNestedVar(FunctionIntro fi, ObjectActionHandler meth, VarPattern vp) {
        this.patterns.add(new PO(vp, fi, meth));
    }

    @Override
    public void recordNestedVar(FunctionIntro fi, ObjectActionHandler meth, TypedPattern tp) {
        this.patterns.add(new PO(tp, fi, meth));
    }

    @Override
    public void recordDependency(LogicHolder fn) {
        if (fn == null) {
            throw new RuntimeException("Cannot depend on null function");
        }
        logger.debug("  " + this + " depends on " + fn.name().uniqueName());
        this.deps.add(fn);
    }

    @Override
    public void recordHandlerDependency(HandlerImplements hi) {
        if (hi == null) {
            throw new RuntimeException("Cannot depend on null function");
        }
        logger.debug("  " + this + " depends on " + hi.name().uniqueName());
        this.hideps.add(hi);
    }

    @Override
    public int size() {
        return this.patterns.size();
    }

    @Override
    public void bindLambda(int which, HandlerLambda hl) {
        ((PO)CollectionUtils.nth(this.patterns, (int)which)).var.bind(hl);
    }

    @Override
    public boolean containsReferencesNotIn(Set<LogicHolder> resolved) {
        HashSet<LogicHolder> ret = new HashSet<LogicHolder>(this.deps);
        for (HandlerImplements hi : this.hideps) {
            for (ObjectMethod mi : hi.implementationMethods) {
                ret.add(mi);
            }
        }
        ret.removeAll(resolved);
        return !ret.isEmpty();
    }

    @Override
    public Set<LogicHolder> references() {
        return this.deps;
    }

    @Override
    public Set<HandlerImplements> referencesHI() {
        return this.hideps;
    }

    @Override
    public Set<LogicHolder> referencesHIMethods() {
        HashSet<LogicHolder> ret = new HashSet<LogicHolder>();
        for (HandlerImplements hi : this.hideps) {
            for (ObjectMethod m : hi.implementationMethods) {
                ret.add(m);
            }
        }
        return ret;
    }

    @Override
    public boolean dependsOn(LogicHolder fn) {
        if (this.deps.contains(fn)) {
            return true;
        }
        return this.referencesHIMethods().contains(fn);
    }

    @Override
    public boolean enhanceWith(LogicHolder sd, NestedVarReader nestedVars) {
        if (nestedVars == null) {
            return false;
        }
        boolean more = false;
        TreeSet<PO> ops = ((MappingStore)nestedVars).patterns;
        for (PO o : ops) {
            if (sd.isMyName(o.name.scope)) continue;
            if (sd instanceof FunctionDefinition) {
                FunctionDefinition fn = (FunctionDefinition)sd;
                for (FunctionIntro fi : fn.intros()) {
                    more |= this.patterns.add(new PO(o, fi, null));
                }
                continue;
            }
            if (sd instanceof ObjectMethod) {
                more |= this.patterns.add(new PO(o, null, (ObjectActionHandler)((ObjectMethod)sd)));
                continue;
            }
            throw new NotImplementedException("cannot enhance a " + sd.getClass().getName() + ": " + sd.name());
        }
        return more;
    }

    @Override
    public Collection<HSIOptions> all() {
        return this.patterns.stream().map(po -> po.opts).collect(Collectors.toList());
    }

    @Override
    public List<UnresolvedVar> vars() {
        return this.patterns.stream().map(po -> po.var).collect(Collectors.toList());
    }

    @Override
    public List<Pattern> patterns() {
        return this.patterns.stream().map(po -> po.p).collect(Collectors.toList());
    }

    public boolean isInteresting() {
        return !this.patterns.isEmpty() || !this.deps.isEmpty() || !this.hideps.isEmpty();
    }

    @Override
    public void clearPatterns() {
        this.patterns.clear();
    }

    public String toString() {
        return "NV[" + this.name.uniqueName() + "]";
    }

    public class PO
    implements Comparable<PO> {
        VarName name;
        Pattern p;
        HSIPatternOptions opts;
        UnresolvedVar var;

        public PO(VarPattern p, FunctionIntro fi, ObjectActionHandler meth) {
            this(fi, meth, p, p.name());
            this.opts.addVar(p, fi);
            this.var.bind(p);
        }

        public PO(TypedPattern p, FunctionIntro fi, ObjectActionHandler meth) {
            this(fi, meth, p, p.name());
            this.opts.addTyped(p, fi);
            this.var.bind(p);
        }

        public PO(PO o, FunctionIntro fi, ObjectActionHandler meth) {
            this(fi, meth, new VarPattern(o.p.location(), o.name), o.name);
            VarPattern mp = (VarPattern)this.p;
            if (o.p instanceof TypedPattern) {
                TypedPattern tp = (TypedPattern)o.p;
                this.opts.addVarWithType(tp.type, tp.var, fi);
                this.var.bind(tp);
                mp.bindType(tp.type());
            } else {
                VarPattern vp = (VarPattern)o.p;
                this.opts.addVar(vp, fi);
                this.var.bind(vp);
                if (vp.hasBoundType()) {
                    mp.bindType(vp.type());
                } else {
                    vp.transitiveBind(mp);
                }
            }
        }

        private PO(FunctionIntro fi, ObjectActionHandler meth, Pattern p, VarName name) {
            this.p = p;
            this.name = name;
            this.opts = new HSIPatternOptions();
            if (fi != null) {
                this.opts.includes(fi);
                this.var = new UnresolvedVar(fi.location, this.name.var);
            } else {
                this.var = new UnresolvedVar(meth.location(), this.name.var);
            }
        }

        @Override
        public int compareTo(PO o) {
            return this.name().compareTo(o.name());
        }

        private String name() {
            return this.name.uniqueName();
        }
    }
}

