/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lifting;

import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.lifting.MappingCollector;
import org.flasck.flas.lifting.VarDependencyMapper;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.TypeBinder;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.repository.RepositoryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;

public class MappingAnalyzer {
    public static final Logger logger = LoggerFactory.getLogger((String)"Lifter");
    private final TypeBinder fn;
    private final MappingCollector collector;
    private final VarDependencyMapper dependencies;
    private FunctionName name;
    private FunctionIntro fi;
    private ObjectActionHandler meth;

    public MappingAnalyzer(TypeBinder fn, MappingCollector c, VarDependencyMapper dependencies) {
        this.fn = fn;
        this.collector = c;
        this.dependencies = dependencies;
    }

    public void visitFunctionIntro(FunctionIntro fi) {
        this.fi = fi;
        this.name = fi.name();
    }

    public void visitObjectMethod(ObjectActionHandler meth) {
        this.meth = meth;
        this.name = meth.name();
    }

    public void visitTypeReference(TypeReference tr) {
        RepositoryEntry defn = (RepositoryEntry)((Object)tr.namedDefn());
        if (defn == null) {
            throw new CantHappenException("should have a definition by this point");
        }
        this.visitDefn(defn);
    }

    public void visitUnresolvedVar(UnresolvedVar vr) {
        RepositoryEntry defn = vr.defn();
        if (defn == null) {
            throw new CantHappenException("should have a definition by this point");
        }
        this.visitDefn(defn);
    }

    public void visitDefn(RepositoryEntry defn) {
        if (defn instanceof VarPattern) {
            VarPattern vp = (VarPattern)defn;
            if (vp.name().scope != this.name) {
                this.collector.recordNestedVar(this.fi, this.meth, vp);
                logger.debug("  uses var " + vp.name());
                this.dependencies.recordVarDependency(this.name, (FunctionName)vp.name().scope, this.collector);
                this.collector.recordDependency(vp.definedBy());
            }
        } else if (defn instanceof TypedPattern) {
            TypedPattern tp = (TypedPattern)defn;
            if (tp.name().scope != this.name) {
                this.collector.recordNestedVar(this.fi, this.meth, tp);
                if (tp.definedBy() == null) {
                    throw new CantHappenException("cannot depend on " + tp.var + " because its definedBy function has not been set");
                }
                logger.debug("  uses var " + tp.name());
                this.collector.recordDependency(tp.definedBy());
            }
        } else if (defn instanceof LogicHolder) {
            if (defn != this.fn) {
                this.collector.recordDependency((LogicHolder)((Object)defn));
            }
        } else if (defn instanceof HandlerImplements && defn != this.fn) {
            this.collector.recordHandlerDependency((HandlerImplements)defn);
        }
    }
}

