/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lifting;

import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.lifting.MappingCollector;
import org.flasck.flas.lifting.MappingStore;
import org.flasck.flas.lifting.VarDependencyMapper;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.zinutils.collections.SetMap;

public class LiftingDependencyMapper
implements VarDependencyMapper {
    private Map<FunctionName, LogicHolder> functions = new TreeMap<FunctionName, LogicHolder>();
    private SetMap<FunctionName, FunctionName> dependencies = new SetMap();

    public void recordFunction(LogicHolder fn) {
        this.functions.put(fn.name(), fn);
        if (this.dependencies.contains((Object)fn.name())) {
            for (FunctionName user : this.dependencies.get((Object)fn.name())) {
                LogicHolder provider = this.functions.get(user);
                MappingStore ms = (MappingStore)provider.nestedVars();
                if (ms == null) {
                    ms = new MappingStore(fn.name());
                    provider.nestedVars(ms);
                }
                ms.recordDependency(fn);
            }
            this.dependencies.removeAll((Object)fn.name());
        }
    }

    public void recordMethod(StandaloneMethod meth) {
    }

    @Override
    public void recordVarDependency(FunctionName user, FunctionName provider, MappingCollector collector) {
        if (this.functions.containsKey(provider)) {
            LogicHolder pf = this.functions.get(provider);
            collector.recordDependency(pf);
        } else {
            this.dependencies.add((Object)provider, (Object)user);
        }
    }
}

