/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.Lexer;
import org.flasck.flas.grammar.ProductionVisitor;
import org.flasck.flas.grammar.SentenceProducer;

public class TokenDefinition
extends Definition {
    private final String token;
    private final String patternMatcher;
    private final SentenceProducer.UseNameForScoping scoping;
    private final List<Matcher> matchers = new ArrayList<Matcher>();
    private final boolean repeatLast;
    private final boolean saveLast;
    private final String generator;
    private final boolean space;

    public TokenDefinition(String token, String patternMatcher, SentenceProducer.UseNameForScoping scoping, boolean repeatLast, boolean saveLast, String generator, boolean space) {
        this.token = token;
        this.patternMatcher = patternMatcher;
        this.scoping = scoping;
        this.repeatLast = repeatLast;
        this.saveLast = saveLast;
        this.generator = generator;
        this.space = space;
    }

    public boolean isToken(Grammar grammar, String rule, String text) {
        if (this.token.equals(rule)) {
            return true;
        }
        if (text == null) {
            return false;
        }
        Lexer lexer = grammar.findToken(this.token);
        String patt = lexer.pattern;
        return text.matches(patt);
    }

    public String token() {
        return this.token;
    }

    @Override
    public void showGrammarFor(PrintWriter str) {
        str.append("<span class='production-token'>" + StringEscapeUtils.escapeHtml4((String)this.token) + "</span>");
    }

    @Override
    public void collectReferences(Set<String> ret) {
    }

    @Override
    public void collectTokens(Set<String> ret) {
        ret.add(this.token);
    }

    @Override
    public void visit(ProductionVisitor productionVisitor) {
        productionVisitor.token(this.token, this.patternMatcher, this.scoping, this.matchers, this.repeatLast, this.saveLast, this.generator, this.space);
    }

    public void addMatcher(String amendedName, String pattern, SentenceProducer.UseNameForScoping scoper) {
        this.matchers.add(new Matcher(amendedName, pattern, scoper));
    }

    public String toString() {
        return "Token[" + this.token + "]";
    }

    public class Matcher {
        public final String amendedName;
        public final String pattern;
        public final SentenceProducer.UseNameForScoping scoper;

        public Matcher(String amendedName, String pattern, SentenceProducer.UseNameForScoping scoper) {
            this.amendedName = amendedName;
            this.pattern = pattern;
            this.scoper = scoper;
        }
    }
}

