/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.ProductionVisitor;
import org.flasck.flas.grammar.ReducesAs;
import org.zinutils.exceptions.CantHappenException;

public class SequenceDefinition
extends Definition {
    private List<Definition> elts = new ArrayList<Definition>();
    private ReducesAs baseReducesAs;
    private boolean borrowFinalIndent;

    public String reducesAs() {
        if (this.baseReducesAs == null) {
            return null;
        }
        if (this.baseReducesAs.base == null) {
            return this.baseReducesAs.ruleName;
        }
        return this.baseReducesAs.ruleName + this.baseReducesAs.base;
    }

    public String reducesAs(List<String> options) {
        if (options.isEmpty()) {
            return this.reducesAs();
        }
        StringBuilder sb = new StringBuilder(this.baseReducesAs.ruleName);
        for (String s : options) {
            sb.append(s);
        }
        return sb.toString();
    }

    public void add(Definition defn) {
        if (defn instanceof ReducesAs) {
            if (this.baseReducesAs != null) {
                throw new CantHappenException("can't define base reduces-as multiple times");
            }
            this.baseReducesAs = (ReducesAs)defn;
            return;
        }
        this.elts.add(defn);
    }

    public int length() {
        return this.elts.size();
    }

    public Definition nth(int offset) {
        return this.elts.get(offset);
    }

    @Override
    public void showGrammarFor(PrintWriter str) {
        boolean first = true;
        for (Definition d : this.elts) {
            if (!first) {
                str.print("&nbsp;");
            }
            first = false;
            d.showGrammarFor(str);
        }
    }

    @Override
    public void collectReferences(Set<String> ret) {
        for (Definition d : this.elts) {
            d.collectReferences(ret);
        }
    }

    @Override
    public void collectTokens(Set<String> ret) {
        for (Definition d : this.elts) {
            d.collectTokens(ret);
        }
    }

    @Override
    public void visit(ProductionVisitor productionVisitor) {
        for (Definition d : this.elts) {
            d.visit(productionVisitor);
        }
    }

    public Definition cloneWith(List<Definition> elts) {
        SequenceDefinition ret = new SequenceDefinition();
        ret.elts.addAll(elts);
        ret.baseReducesAs = this.baseReducesAs;
        ret.borrowFinalIndent = this.borrowFinalIndent;
        return ret;
    }

    public void borrowFinalIndent(boolean bool) {
        this.borrowFinalIndent = bool;
    }

    public boolean borrowFinalIndent() {
        return this.borrowFinalIndent;
    }

    public boolean hasExplicitReduceAs() {
        return this.baseReducesAs != null;
    }
}

