/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.Lexer;
import org.flasck.flas.grammar.OrProduction;
import org.flasck.flas.grammar.Production;
import org.flasck.flas.grammar.ProductionVisitor;
import org.flasck.flas.grammar.RefDefinition;
import org.flasck.flas.grammar.SentenceData;
import org.flasck.flas.grammar.TokenDefinition;
import org.junit.Assert;
import org.zinutils.utils.FileUtils;
import org.zinutils.xml.XML;

public class SentenceProducer {
    private boolean debug = false;
    private final Grammar grammar;
    private final File td;

    public SentenceProducer(File td, String grammar) {
        this.td = td;
        this.grammar = Grammar.from(XML.fromResource((String)grammar));
    }

    public void sentence(long var, String top, Consumer<SentenceData> sendUsed) throws Throwable {
        String ext;
        String pkg = "test.r" + var;
        File root = new File(this.td, pkg);
        FileUtils.assertDirectory((File)root);
        if (top.equals("source-file")) {
            ext = ".fl";
        } else if (top.equals("unit-test-file")) {
            ext = ".ut";
        } else if (top.equals("system-test-file")) {
            ext = ".st";
        } else {
            throw new RuntimeException("Cannot generate " + top);
        }
        File tmp = new File(root, "r" + Long.toString(var) + ext);
        SPProductionVisitor visitor = new SPProductionVisitor(this.grammar, pkg, tmp.getName(), var * 100L);
        visitor.referTo(top, false);
        FileUtils.writeFile((File)tmp, (String)visitor.sentence.toString());
        sendUsed.accept(new SentenceData(visitor.used, visitor.matchers, tmp));
    }

    public void debugMode() {
        this.debug = true;
    }

    public class SPProductionVisitor
    implements ProductionVisitor {
        private StringBuilder sentence = new StringBuilder();
        private final Grammar grammar;
        private final String fileName;
        private final Random r;
        private int indent = 1;
        private boolean haveSomething;
        private Set<String> used = new TreeSet<String>();
        private List<NamePart> nameParts = new ArrayList<NamePart>();
        private Map<String, String> matchers = new TreeMap<String, String>();
        private String futureAmended;
        private String futurePattern;
        private Set<String> tokens = new HashSet<String>();
        private int nameNestOffset;
        private final List<Map<String, String>> dicts = new ArrayList<Map<String, String>>();

        public SPProductionVisitor(Grammar g, String pkg, String fileName, long l) {
            this.grammar = g;
            this.fileName = fileName;
            this.r = new Random(l);
            this.nameParts.add(new NamePart(0, pkg, UseNameForScoping.UNSCOPED));
            this.dicts.add(null);
            this.dicts.add(new TreeMap());
        }

        @Override
        public void visit(Definition child) {
            child.visit(this);
        }

        @Override
        public void zeroOrOne(Definition child) {
            boolean wanted = this.r.nextBoolean();
            if (SentenceProducer.this.debug) {
                System.out.println("Choosing " + wanted + " for optional " + child);
            }
            if (wanted) {
                this.visit(child);
            }
        }

        @Override
        public int zeroOrMore(Definition child, boolean withEOL) {
            int cnt = this.r.nextInt(3);
            this.iterateOver(child, withEOL, cnt);
            return cnt;
        }

        @Override
        public int oneOrMore(Definition child, boolean withEOL) {
            int cnt = this.r.nextInt(3) + 1;
            this.iterateOver(child, withEOL, cnt);
            return cnt;
        }

        @Override
        public void exactly(int cnt, Definition child, boolean withEOL) {
            this.iterateOver(child, withEOL, cnt);
        }

        private void iterateOver(Definition child, boolean withEOL, int cnt) {
            OrProduction op = null;
            OrState cxt = null;
            if (child instanceof RefDefinition && (op = ((RefDefinition)child).isOr(this)) != null) {
                cxt = new OrState(op);
            }
            if (SentenceProducer.this.debug) {
                System.out.println("Choosing " + cnt + " iterations of " + child);
            }
            for (int i = 0; i < cnt; ++i) {
                if (op != null) {
                    op.visitWith(cxt, this);
                } else {
                    this.visit(child);
                }
                if (!withEOL) continue;
                this.generateEOL();
            }
            if (op != null) {
                while (!op.wrapUp(cxt, this)) {
                    if (!withEOL) continue;
                    this.generateEOL();
                }
            }
        }

        @Override
        public void referTo(String child, boolean resetToken) {
            Production p;
            if (resetToken) {
                this.dicts.get(this.dicts.size() - 1).remove("haveLast");
                this.dicts.get(this.dicts.size() - 1).remove("caseNumber");
            }
            try {
                p = this.grammar.findRule(child);
                if (!(p instanceof OrProduction)) {
                    String rn = p.ruleNumber() + " " + p.ruleName();
                    this.used.add(rn);
                    if (SentenceProducer.this.debug) {
                        System.out.println("Rule " + rn);
                    }
                }
            }
            catch (RuntimeException ex) {
                System.out.println(ex);
                return;
            }
            p.visit(this);
        }

        @Override
        public OrProduction isOr(String child) {
            Production p = this.grammar.findRule(child);
            if (p instanceof OrProduction) {
                return (OrProduction)p;
            }
            return null;
        }

        @Override
        public void choices(OrProduction prod, Object cxt, List<Definition> asList, List<Integer> probs, int maxProb, boolean repeatVarName) {
            OrState os = (OrState)cxt;
            int ni = this.r.nextInt(maxProb);
            for (int i = 0; i < asList.size(); ++i) {
                Definition cd = asList.get(i);
                RefDefinition rd = null;
                if (cd instanceof RefDefinition) {
                    rd = (RefDefinition)cd;
                }
                if (probs.get(i) <= ni || rd != null && os != null && os.cnts.get(i) >= rd.getTo()) continue;
                String rn = prod.ruleNumber() + "." + (i + 1) + " " + prod.ruleName();
                this.used.add(rn);
                if (SentenceProducer.this.debug) {
                    System.out.println("Rule " + rn);
                }
                this.visit(cd);
                if (os != null) {
                    os.cnts.set(i, os.cnts.get(i) + 1);
                }
                return;
            }
        }

        @Override
        public boolean complete(OrProduction prod, Object cxt, List<Definition> choices) {
            OrState os = (OrState)cxt;
            for (int i = 0; i < choices.size(); ++i) {
                if (!(choices.get(i) instanceof RefDefinition)) continue;
                RefDefinition d = (RefDefinition)choices.get(i);
                if (os.cnts.get(i) >= d.getFrom()) continue;
                String rn = prod.ruleNumber() + "." + (i + 1) + " " + prod.ruleName();
                this.used.add(rn);
                if (SentenceProducer.this.debug) {
                    System.out.println("Rule " + rn);
                }
                this.visit(d);
                os.cnts.set(i, os.cnts.get(i) + 1);
                return false;
            }
            return true;
        }

        @Override
        public void token(String token, String patternMatcher, UseNameForScoping scoping, List<TokenDefinition.Matcher> matchers, boolean repeatLast, boolean saveLast, String generator, boolean space) {
            String t;
            boolean mayRepeat;
            Lexer lexer = this.grammar.findToken(token);
            String haveLast = this.dicts.get(this.indent).get("haveLast");
            String allowRepeat = this.dicts.get(this.indent).get("allow-repeat-last");
            boolean bl = mayRepeat = allowRepeat == null || allowRepeat.equals("true");
            if (mayRepeat && repeatLast && haveLast != null) {
                t = haveLast;
            } else {
                t = this.genToken(token, lexer.pattern, generator);
                if (saveLast) {
                    this.dicts.get(this.indent).put("haveLast", t);
                }
            }
            if (SentenceProducer.this.debug) {
                System.out.println("    " + t);
            }
            if (generator == null) {
                Pattern p = Pattern.compile(lexer.pattern);
                Assert.assertTrue((String)("generated token for " + token + "(" + t + ") did not match pattern definition (" + lexer.pattern + ")"), (boolean)p.matcher(t).matches());
            }
            if (!this.haveSomething) {
                for (int i = 0; i < this.indent; ++i) {
                    this.sentence.append("\t");
                }
            } else if (space) {
                this.sentence.append(" ");
            }
            this.haveSomething = true;
            this.sentence.append(t);
            if (patternMatcher != null) {
                this.replace(t, scoping);
                this.matchers.put(this.assembleName(t.replaceFirst("^_", ""), scoping), patternMatcher);
            }
            for (TokenDefinition.Matcher m : matchers) {
                String patt = m.pattern;
                String doAmend = t;
                if (patt == null) {
                    if (this.futurePattern == null) {
                        throw new RuntimeException("Cannot use pattern because it has not been set");
                    }
                    patt = this.futurePattern;
                    this.futurePattern = null;
                    if (this.futureAmended != null) {
                        doAmend = this.futureAmended.replace("${final}", t);
                    }
                }
                if (m.amendedName != null) {
                    doAmend = m.amendedName.replace("${final}", t);
                }
                this.replace(doAmend, m.scoper);
                this.matchers.put(this.assembleName(doAmend, scoping), patt);
            }
        }

        @Override
        public void generateEOL() {
            this.haveSomething = false;
            this.sentence.append("\n");
        }

        @Override
        public void setDictEntry(String var, String val) {
            this.dicts.get(this.indent).put(var, val);
        }

        @Override
        public String getDictValue(String var) {
            for (int i = this.dicts.size() - 1; i >= 1; --i) {
                Map<String, String> m = this.dicts.get(i);
                if (!m.containsKey(var)) continue;
                return m.get(var);
            }
            return null;
        }

        @Override
        public String getTopDictValue(String var) {
            return this.dicts.get(this.dicts.size() - 1).get(var);
        }

        @Override
        public void clearDictEntry(String var) {
            this.dicts.get(this.indent).remove(var);
        }

        @Override
        public void condNotEqual(String var, String ne, Definition inner) {
            String val = this.getDictValue(var);
            if (val != null) {
                if (!val.equals(ne)) {
                    this.visit(inner);
                }
                return;
            }
            throw new RuntimeException("The condition var " + var + " was not set");
        }

        @Override
        public void condNotSet(String var, Definition inner) {
            Map<String, String> m = this.dicts.get(this.dicts.size() - 1);
            if (!m.containsKey(var)) {
                this.visit(inner);
            }
        }

        private void replace(String t, UseNameForScoping scoping) {
            NamePart np = null;
            for (NamePart p : this.nameParts) {
                if (p.indentLevel != this.indent + this.nameNestOffset) continue;
                np = p;
            }
            if (np != null && scoping != UseNameForScoping.USE_CURRENT_NAME && scoping != UseNameForScoping.INDENT_THIS_ONCE) {
                this.removeAbove(this.indent + this.nameNestOffset - 1);
            }
            if (np == null || scoping != UseNameForScoping.USE_CURRENT_NAME && scoping != UseNameForScoping.INDENT_THIS_ONCE) {
                this.nameParts.add(new NamePart(this.indent + this.nameNestOffset, t, scoping));
            }
        }

        @Override
        public void futurePattern(String amended, String pattern) {
            if (this.futurePattern != null) {
                throw new RuntimeException("Cannot set next pattern without using previous pattern");
            }
            this.futureAmended = amended;
            this.futurePattern = pattern;
        }

        @Override
        public void nestName(int offset) {
            this.nameNestOffset = offset;
        }

        @Override
        public void pushPart(String prefix, String names, boolean appendFileName) {
            NamePart np = null;
            for (NamePart p : this.nameParts) {
                if (p.indentLevel != this.indent + this.nameNestOffset - 1) continue;
                np = p;
            }
            this.removeAbove(this.indent + this.nameNestOffset - 1);
            if (appendFileName) {
                if (this.nameParts.size() != 1) {
                    throw new RuntimeException("Should only append file name at top level");
                }
                int idx = this.fileName.lastIndexOf(46);
                String ext = this.fileName.substring(idx + 1);
                String fn = this.fileName.substring(0, idx).replace('.', '_');
                this.nameParts.add(new NamePart(this.indent + this.nameNestOffset - 1, "_" + ext + "_" + fn, UseNameForScoping.UNSCOPED));
            }
            if (prefix != null) {
                NamePart finalPart = new NamePart(this.indent + this.nameNestOffset, "_" + prefix + np.serviceNamer++, UseNameForScoping.UNSCOPED);
                this.nameParts.add(finalPart);
                if (names != null) {
                    this.matchers.put(this.assembleName(finalPart.name, UseNameForScoping.UNSCOPED), names);
                }
            }
        }

        @Override
        public void pushCaseNumber() {
            this.removeAbove(this.indent + this.nameNestOffset);
            String allowRepeat = this.dicts.get(this.indent).get("allow-repeat-last");
            boolean mayRepeat = allowRepeat == null || allowRepeat.equals("true");
            String cn = this.getTopDictValue("caseNumber");
            cn = !mayRepeat || cn == null ? "1" : Integer.toString(Integer.parseInt(cn) + 1);
            this.setDictEntry("caseNumber", cn);
            NamePart finalPart = new NamePart(this.indent + this.nameNestOffset, "_" + cn, UseNameForScoping.UNSCOPED);
            this.nameParts.add(finalPart);
        }

        private String assembleName(String desiredName, UseNameForScoping scoping) {
            StringBuilder sb = new StringBuilder();
            int drop = scoping == UseNameForScoping.INDENT_THIS_ONCE ? 0 : 1;
            for (int i = 0; i < this.nameParts.size() - drop; ++i) {
                NamePart np = this.nameParts.get(i);
                sb.append(np.name);
                sb.append(".");
            }
            sb.append(desiredName);
            return sb.toString();
        }

        @Override
        public boolean indent(boolean force) {
            this.sentence.append("\n");
            if (!(force || this.haveSomething && this.indent < 8)) {
                this.haveSomething = false;
                return false;
            }
            this.haveSomething = false;
            ++this.indent;
            this.dicts.add(new TreeMap());
            return true;
        }

        @Override
        public void exdent() {
            this.removeAbove(--this.indent - 1);
            if (this.haveSomething) {
                this.sentence.append("\n");
            }
            this.haveSomething = false;
            while (this.dicts.size() > this.indent + 1) {
                this.dicts.remove(this.dicts.size() - 1);
            }
        }

        public void removeAbove(int above) {
            int i = 0;
            while (i < this.nameParts.size()) {
                NamePart part = this.nameParts.get(i);
                if (part.indentLevel > above) {
                    this.nameParts.remove(i);
                    continue;
                }
                ++i;
            }
        }

        private String genToken(String token, String pattern, String generator) {
            if (generator != null) {
                return this.generateTokenUsing(generator);
            }
            switch (token) {
                case "APPLY": {
                    return ".";
                }
                case "CCB": {
                    return "}";
                }
                case "CRB": {
                    return ")";
                }
                case "CSB": {
                    return "]";
                }
                case "EOL": {
                    return "\n";
                }
                case "EQ": {
                    return "=";
                }
                case "GUARD": 
                case "OR": {
                    return "|";
                }
                case "OCB": {
                    return "{";
                }
                case "ORB": {
                    return "(";
                }
                case "OSB": {
                    return "[";
                }
                case "COLON": 
                case "COMMA": 
                case "HANDLE": 
                case "PUT": 
                case "SEND": 
                case "SENDTO": {
                    return pattern;
                }
                case "ACOR": 
                case "AGENT": 
                case "AJAX": 
                case "ASSERT": 
                case "CARD": 
                case "CONFIGURE": 
                case "CONTRACT": 
                case "CREATE": 
                case "CTOR": 
                case "DATA": 
                case "DEAL": 
                case "ENTITY": 
                case "ENVELOPE": 
                case "EVENT": 
                case "EXPECT": 
                case "FINALLY": 
                case "HANDLER": 
                case "HEADER": 
                case "IMPLEMENTS": 
                case "INVOKE": 
                case "MATCH": 
                case "METHOD": 
                case "OBJECT": 
                case "OFFER": 
                case "OPTIONAL": 
                case "PROVIDES": 
                case "PUMP": 
                case "QUERY": 
                case "REQUIRES": 
                case "RESPONSES": 
                case "SERVICE": 
                case "SHOVE": 
                case "STATE": 
                case "STRUCT": 
                case "STYLE": 
                case "SUBSCRIBE": 
                case "TEMPLATE": 
                case "TEST": 
                case "TEXT": 
                case "TYPE": 
                case "UNION": 
                case "WRAPS": {
                    return token.toLowerCase();
                }
                case "FALSE": 
                case "TRUE": {
                    return StringUtils.capitalize((String)token.toLowerCase());
                }
                case "BINOP": {
                    return this.oneOf("+", "-", "*", "/");
                }
                case "DOSEND": {
                    return "send";
                }
                case "NUMBER": {
                    return this.randomChars(1, 1, '1', 9) + this.randomChars(0, 3, '0', 10);
                }
                case "STRING": {
                    return "'" + this.randomChars(10, 20, '!', 90).replaceAll("'", "_") + "'";
                }
                case "TESTDESCRIPTION": {
                    return this.randomChars(5, 10, 'a', 26);
                }
                case "UNOP": {
                    return "-";
                }
                case "poly-var": {
                    return this.unique(() -> this.randomChars(1, 2, 'A', 26));
                }
                case "type-name": {
                    return this.unique(() -> this.randomChars(1, 1, 'A', 26) + this.randomChars(2, 8, 'a', 26));
                }
                case "event-name": 
                case "template-name": 
                case "var-name": {
                    return this.unique(() -> this.randomChars(1, 8, 'a', 26));
                }
                case "introduce-var": {
                    return this.unique(() -> "_" + this.randomChars(1, 8, 'a', 26));
                }
            }
            throw new RuntimeException("Cannot generate a token for " + token);
        }

        private String generateTokenUsing(String generator) {
            switch (generator) {
                case "uri": {
                    return "'https://random-uri'";
                }
                case "uri-path": {
                    return "'/foo'";
                }
            }
            throw new RuntimeException("There is no generator for " + generator);
        }

        private String unique(Supplier<String> supplier) {
            for (int j = 0; j < 100; ++j) {
                String tok = supplier.get();
                if (this.tokens.contains(tok)) continue;
                this.tokens.add(tok);
                return tok;
            }
            throw new RuntimeException("Could not find unique token among " + this.tokens);
        }

        private String oneOf(String ... strings) {
            int k = this.r.nextInt(strings.length);
            return strings[k];
        }

        private String randomChars(int min, int max, char fst, int range) {
            int len = min;
            if (max > min) {
                len += this.r.nextInt(max - min);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                sb.append((char)(fst + this.r.nextInt(range)));
            }
            return sb.toString();
        }
    }

    public class NamePart {
        private final int indentLevel;
        private final String name;
        private final UseNameForScoping scoping;
        public int serviceNamer;

        public NamePart(int indent, String token, UseNameForScoping scoping) {
            this.indentLevel = indent;
            this.name = token;
            this.scoping = scoping;
        }

        public String toString() {
            return this.indentLevel + ":" + this.name + "." + this.scoping;
        }
    }

    public static enum UseNameForScoping {
        USE_THIS_NAME,
        USE_CURRENT_NAME,
        INDENT_THIS_ONCE,
        UNSCOPED;

    }

    public class OrState {
        public List<Integer> cnts = new ArrayList<Integer>();

        public OrState(OrProduction op) {
            for (int i = 0; i < op.size(); ++i) {
                this.cnts.add(0);
            }
        }
    }
}

