/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.PrintWriter;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.OrProduction;
import org.flasck.flas.grammar.Production;
import org.flasck.flas.grammar.ProductionVisitor;

public class RefDefinition
extends Definition {
    private final String child;
    private final boolean resetToken;
    private final int from;
    private final int to;

    public RefDefinition(String child, boolean resetToken, int from, int to) {
        this.child = child;
        this.resetToken = resetToken;
        this.from = from;
        this.to = to;
    }

    public boolean refersTo(String rule) {
        return this.child.equals(rule);
    }

    public String ruleName() {
        return this.child;
    }

    public Production production(Grammar grammar) {
        return grammar.findRule(this.child);
    }

    @Override
    public void showGrammarFor(PrintWriter str) {
        str.append("<span class='production-reference'>&lt;" + StringEscapeUtils.escapeHtml4((String)this.child) + "&gt;</span>");
    }

    @Override
    public void collectReferences(Set<String> ret) {
        ret.add(this.child);
    }

    @Override
    public void collectTokens(Set<String> ret) {
    }

    public OrProduction isOr(ProductionVisitor productionVisitor) {
        return productionVisitor.isOr(this.child);
    }

    @Override
    public void visit(ProductionVisitor productionVisitor) {
        productionVisitor.referTo(this.child, this.resetToken);
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public String toString() {
        return "Ref[" + this.child + "]";
    }
}

