/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.PrintWriter;
import java.util.Set;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.OrProduction;
import org.flasck.flas.grammar.ProductionVisitor;

public class Production {
    public final int number;
    public final String name;
    public final Definition defn;
    public final String description;
    private boolean needsMoreTesting;

    public Production(int ruleNumber, String ruleName, Definition defn, String desc) {
        this.number = ruleNumber;
        this.name = ruleName;
        this.defn = defn;
        this.description = desc;
    }

    public String ruleName() {
        return this.name;
    }

    public int ruleNumber() {
        return this.number;
    }

    public void show(PrintWriter str, boolean includeDesc) {
        if (!(this instanceof OrProduction)) {
            str.println("<div class='production-rule'>");
        }
        str.println("<div class='production-block'>");
        str.println("  <div class='production-number" + this.highlightTestingNeeded() + "'>(" + this.number + ")</div>");
        str.println("  <div class='production-name'>" + this.name + "</div>");
        str.println("  <div class='production-op'>::=</div>");
        this.defn.showGrammarFor(str);
        str.println("</div>");
        if (includeDesc && this.description != null) {
            str.println("  <div class='production-desc'>");
            str.println(this.description);
            str.println("  </div>");
        }
        if (!(this instanceof OrProduction)) {
            str.println("</div>");
        }
    }

    private String highlightTestingNeeded() {
        return "";
    }

    public void collectReferences(Set<String> ret) {
        this.defn.collectReferences(ret);
    }

    public void collectTokens(Set<String> ret) {
        this.defn.collectTokens(ret);
    }

    public void visit(ProductionVisitor visitor) {
        visitor.visit(this.defn);
    }

    public void needsMoreTesting() {
        this.needsMoreTesting = true;
    }
}

