/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Production;
import org.flasck.flas.grammar.ProductionVisitor;

public class OrProduction
extends Production {
    private final List<Definition> otherDefns = new ArrayList<Definition>();
    private final List<Definition> choices;
    private final boolean repeatVarName;
    private int maxProb;
    private List<Integer> probs = new ArrayList<Integer>();

    public OrProduction(int ruleNumber, String ruleName, List<Definition> defns, boolean repeatVarName, String desc) {
        super(ruleNumber, ruleName, defns.get(0), desc);
        this.choices = defns;
        this.repeatVarName = repeatVarName;
        this.otherDefns.addAll(defns);
        this.otherDefns.remove(0);
        this.maxProb = defns.size();
        for (int i = 0; i < this.maxProb; ++i) {
            this.probs.add(i + 1);
        }
    }

    public List<Definition> allOptions() {
        return this.choices;
    }

    public void add(Definition r) {
        this.choices.add(r);
        this.otherDefns.add(r);
        this.probs.add(this.choices.size());
    }

    public int size() {
        return this.choices.size();
    }

    @Override
    public void show(PrintWriter str, boolean includeDesc) {
        str.println("<div class='production-rule'>");
        super.show(str, false);
        for (Definition d : this.otherDefns) {
            str.println("<div class='production-or-block'>");
            str.println("  <div class='production-or'>|</div>");
            d.showGrammarFor(str);
            str.println("</div>");
        }
        if (includeDesc && this.description != null) {
            str.println("  <div class='production-desc'>");
            str.println(this.description);
            str.println("  </div>");
        }
        str.println("</div>");
        str.flush();
    }

    @Override
    public void collectReferences(Set<String> ret) {
        super.collectReferences(ret);
        for (Definition d : this.otherDefns) {
            d.collectReferences(ret);
        }
    }

    @Override
    public void collectTokens(Set<String> ret) {
        super.collectTokens(ret);
        for (Definition d : this.otherDefns) {
            d.collectTokens(ret);
        }
    }

    @Override
    public void visit(ProductionVisitor visitor) {
        visitor.choices(this, null, this.choices, this.probs, this.maxProb, this.repeatVarName);
    }

    public void probs(List<Integer> probs) {
        if (this.size() != probs.size()) {
            throw new RuntimeException("Have " + probs.size() + " probabilities for " + this.size() + " cases in " + this.name);
        }
        this.probs = new ArrayList<Integer>();
        this.maxProb = 0;
        for (int i : probs) {
            this.probs.add(this.maxProb += i);
        }
    }

    public void visitWith(Object cxt, ProductionVisitor visitor) {
        visitor.choices(this, cxt, this.choices, this.probs, this.maxProb, this.repeatVarName);
    }

    public boolean wrapUp(Object cxt, ProductionVisitor visitor) {
        return visitor.complete(this, cxt, this.choices);
    }
}

