/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.PrintWriter;
import java.util.Set;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.ProductionVisitor;

public class ManyDefinition
extends Definition {
    private final Definition child;
    private final boolean allowZero;
    private final String shared;

    public ManyDefinition(Definition child, boolean allowZero, String shared) {
        this.child = child;
        this.allowZero = allowZero;
        this.shared = shared;
    }

    public Definition repeats() {
        return this.child;
    }

    @Override
    public void showGrammarFor(PrintWriter str) {
        this.child.showGrammarFor(str);
        str.print("<span class='production-many'>");
        if (this.allowZero) {
            str.print("*");
        } else {
            str.print("+");
        }
        str.print("</span>");
    }

    @Override
    public void collectReferences(Set<String> ret) {
        this.child.collectReferences(ret);
    }

    @Override
    public void collectTokens(Set<String> ret) {
        this.child.collectTokens(ret);
    }

    @Override
    public void visit(ProductionVisitor productionVisitor) {
        String cnt;
        if (this.shared != null && (cnt = productionVisitor.getTopDictValue(this.shared)) != null) {
            productionVisitor.exactly(Integer.parseInt(cnt), this.child, false);
            return;
        }
        int actual = this.allowZero ? productionVisitor.zeroOrMore(this.child, false) : productionVisitor.oneOrMore(this.child, false);
        if (this.shared != null) {
            productionVisitor.setDictEntry(this.shared, Integer.toString(actual));
        }
    }

    public String toString() {
        return "Many[" + this.child + "]";
    }
}

