/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.PrintWriter;
import java.util.Set;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.ProductionVisitor;

public class IndentDefinition
extends Definition {
    private final Definition defn;
    private final boolean exactlyOne;
    private final boolean allowZero;
    private String reducesAs;

    public IndentDefinition(Definition defn, boolean exactlyOne, boolean allowZero) {
        this.defn = defn;
        this.exactlyOne = exactlyOne;
        this.allowZero = allowZero;
    }

    public Definition indented() {
        return this.defn;
    }

    @Override
    public void showGrammarFor(PrintWriter str) {
        str.print("<div class='production-nested-block'>");
        str.print("<span class='production-nested'>&gt;&gt;" + (this.exactlyOne ? "!" : (this.allowZero ? "" : "&gt;")) + "</span>");
        this.defn.showGrammarFor(str);
        str.print("</div>");
    }

    @Override
    public void collectReferences(Set<String> ret) {
        this.defn.collectReferences(ret);
    }

    @Override
    public void collectTokens(Set<String> ret) {
        this.defn.collectTokens(ret);
    }

    @Override
    public void visit(ProductionVisitor productionVisitor) {
        if (!productionVisitor.indent(!this.allowZero || this.exactlyOne)) {
            return;
        }
        if (this.exactlyOne) {
            this.defn.visit(productionVisitor);
        } else if (this.allowZero) {
            productionVisitor.zeroOrMore(this.defn, true);
        } else {
            productionVisitor.oneOrMore(this.defn, true);
        }
        productionVisitor.exdent();
    }

    public void reducesAs(String ruleName) {
        this.reducesAs = ruleName;
    }

    public boolean canReduceAs(String ruleName) {
        return this.reducesAs != null && this.reducesAs.equals(ruleName);
    }

    public String reducesTo() {
        return this.reducesAs;
    }

    public String toString() {
        return "Indent[" + this.defn + "]";
    }
}

