/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.File;
import org.flasck.flas.grammar.Grammar;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.utils.FileUtils;
import org.zinutils.xml.XML;

public class GrammarSupport {
    private static File srcDir = new File("src/test/resources/gh-grammar");

    public static File srcDir() {
        return srcDir;
    }

    public static Grammar loadGrammar() {
        String other;
        XML grammarAsXML = XML.fromFile((File)new File(srcDir, "grammar.xml"));
        Grammar grammar = Grammar.from(grammarAsXML);
        int i = 1;
        while ((other = System.getProperty("org.flasck.grammar_load." + i)) != null) {
            File f = new File(other);
            if (!f.canRead()) {
                throw new CantHappenException("the grammar file " + f + " was not found");
            }
            XML merge = XML.fromFile((File)f);
            grammar.mergeIn(merge);
            ++i;
        }
        return grammar;
    }

    static {
        String gr = System.getenv("GRAMMAR_ROOT");
        if (gr == null) {
            gr = System.getProperty("org.flasck.grammar_root");
        }
        if (gr != null) {
            srcDir = FileUtils.combine((File)new File(gr), (File)srcDir);
        }
    }
}

