/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.flas.grammar.CSSFile;
import org.flasck.flas.grammar.CaseNumberingDefinition;
import org.flasck.flas.grammar.CondDefinition;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.DictClearDefinition;
import org.flasck.flas.grammar.DictSetDefinition;
import org.flasck.flas.grammar.ElseClause;
import org.flasck.flas.grammar.GenerateEOL;
import org.flasck.flas.grammar.IndentDefinition;
import org.flasck.flas.grammar.Lexer;
import org.flasck.flas.grammar.ManyDefinition;
import org.flasck.flas.grammar.NestedNameDefinition;
import org.flasck.flas.grammar.OptionalDefinition;
import org.flasck.flas.grammar.OrProduction;
import org.flasck.flas.grammar.Production;
import org.flasck.flas.grammar.PushPartDefinition;
import org.flasck.flas.grammar.ReducesAs;
import org.flasck.flas.grammar.RefDefinition;
import org.flasck.flas.grammar.Section;
import org.flasck.flas.grammar.SentenceProducer;
import org.flasck.flas.grammar.SequenceDefinition;
import org.flasck.flas.grammar.TokenDefinition;
import org.flasck.flas.grammar.WillNameDefinition;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.xml.XML;
import org.zinutils.xml.XMLElement;

public class Grammar {
    public final String title;
    private final LinkedHashMap<String, Section> sections;
    private final LinkedHashMap<String, Production> productions;
    private final Set<Lexer> lexers = new TreeSet<Lexer>();
    private List<CSSFile> cssFiles = new ArrayList<CSSFile>();
    private List<String> jsFiles = new ArrayList<String>();
    private static final String[] mergeableRules = new String[]{"top-level-definition"};

    private Grammar(String title) {
        this.title = title;
        this.sections = new LinkedHashMap();
        this.productions = new LinkedHashMap();
    }

    public static Grammar from(XML xml) {
        XMLElement xe = xml.top();
        xe.assertTag("grammar");
        Grammar ret = new Grammar(xe.required("title"));
        xe.attributesDone();
        ret.readCSSFiles(xe);
        ret.readJSFiles(xe);
        ret.parseLexers(xe);
        ret.parseProductions(xe);
        return ret;
    }

    public void mergeIn(XML merge) {
        XMLElement xe = merge.top();
        xe.assertTag("grammar");
        xe.required("title");
        xe.attributesDone();
        this.readCSSFiles(xe);
        this.readJSFiles(xe);
        this.parseLexers(xe);
        this.parseProductions(xe);
    }

    private void readCSSFiles(XMLElement xe) {
        List css = xe.elementChildren("css");
        for (XMLElement ce : css) {
            this.cssFiles.add(new CSSFile(ce.required("href"), ce.optional("media")));
            ce.attributesDone();
        }
    }

    private void readJSFiles(XMLElement xe) {
        List js = xe.elementChildren("js");
        for (XMLElement je : js) {
            this.jsFiles.add(je.required("href"));
            je.attributesDone();
        }
    }

    private void parseLexers(XMLElement xml) {
        List lexers = xml.elementChildren("lex");
        for (XMLElement xe : lexers) {
            StringBuilder sb = new StringBuilder();
            xe.serializeChildrenTo(sb);
            this.lexers.add(new Lexer(xe.required("token"), xe.required("pattern"), sb.toString()));
            xe.attributesDone();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseProductions(XMLElement xml) {
        List productions = xml.elementChildren("production");
        int ruleNumber = 1;
        for (XMLElement p : productions) {
            Production theProd;
            String ruleName = p.get("name");
            XMLElement section = p.uniqueElement("section");
            Section s = this.requireSection(section);
            List testers = p.elementChildren("tested");
            boolean needsMoreTesting = testers.isEmpty() || testers.size() == 1 && ((XMLElement)testers.get(0)).hasAttribute("have");
            for (XMLElement t : testers) {
                t.optional("by");
                t.attributesDone();
            }
            ArrayList<Integer> probs = null;
            List producers = p.elementChildren("producer");
            if (producers.size() > 1) {
                throw new RuntimeException("Production '" + ruleName + "' had multiple 'producer' blocks");
            }
            if (producers.size() == 1) {
                String[] shares = ((XMLElement)producers.get(0)).required("shares").split(" ");
                probs = new ArrayList<Integer>();
                for (String sh : shares) {
                    probs.add(Integer.parseInt(sh));
                }
            }
            ArrayList<XMLElement> rules = new ArrayList<XMLElement>();
            for (XMLElement r : p.elementChildren()) {
                if (r.hasTag("section") || r.hasTag("description") || r.hasTag("producer") || r.hasTag("tested")) continue;
                rules.add(r);
            }
            if (rules.size() != 1) {
                throw new RuntimeException("Production '" + ruleName + "' did not have exactly one rule but " + rules.size());
            }
            XMLElement rule = (XMLElement)rules.get(0);
            String desc = this.getDescription(p);
            if (rule.hasTag("or")) {
                OrProduction orProd = this.handleOr(ruleNumber++, ruleName, rule, desc);
                theProd = orProd;
                if (probs != null) {
                    orProd.probs(probs);
                }
            } else {
                Definition defn = this.parseDefn(ruleName, rule);
                theProd = new Production(ruleNumber++, ruleName, defn, desc);
            }
            if (this.productions.containsKey(theProd.name)) {
                if (Arrays.binarySearch(mergeableRules, theProd.name) < 0) throw new RuntimeException("Duplicate definition of production " + theProd.name);
                this.mergeInProductions(this.productions.get(theProd.name), theProd);
            } else {
                this.productions.put(theProd.name, theProd);
            }
            if (needsMoreTesting) {
                theProd.needsMoreTesting();
            }
            s.add(theProd);
        }
    }

    private String getDescription(XMLElement rule) {
        if (!rule.elementChildren("description").isEmpty()) {
            StringBuilder sb = new StringBuilder();
            rule.uniqueElement("description").serializeChildrenTo(sb);
            return sb.toString();
        }
        return null;
    }

    private void mergeInProductions(Production original, Production toMerge) {
        if (!original.name.equals(toMerge.name)) {
            throw new CantHappenException("can't merge rules with different names");
        }
        if (!(original instanceof OrProduction)) {
            throw new CantHappenException("the original rule must be an OrProduction to merge");
        }
        OrProduction mergeInto = (OrProduction)original;
        if (toMerge instanceof OrProduction) {
            for (Definition r : ((OrProduction)toMerge).allOptions()) {
                mergeInto.add(r);
            }
        }
    }

    private Section requireSection(XMLElement xe) {
        Section ret;
        String title = xe.required("title");
        if (this.sections.containsKey(title)) {
            ret = this.sections.get(title);
            if (!xe.elementChildren("description").isEmpty()) {
                throw new RuntimeException("Non-first occurrence of section " + title + " had a description that would be ignored");
            }
        } else {
            try {
                ret = new Section(title, xe.uniqueElement("description"));
                this.sections.put(title, ret);
            }
            catch (UtilException ex) {
                throw new RuntimeException("First occurrence of section " + title + " did not have a description");
            }
        }
        xe.attributesDone();
        return ret;
    }

    private OrProduction handleOr(int ruleNumber, String ruleName, XMLElement rule, String desc) {
        boolean repeatVarName = rule.optionalBoolean("quietly-repeat-var-name", false);
        rule.attributesDone();
        List options = rule.elementChildren();
        if (options.size() < 2) {
            throw new RuntimeException("Or must have at least two options");
        }
        ArrayList<Definition> defns = new ArrayList<Definition>();
        for (XMLElement xe : options) {
            defns.add(this.parseDefn(ruleName, xe));
        }
        return new OrProduction(ruleNumber, ruleName, defns, repeatVarName, desc);
    }

    private Definition parseDefn(String ruleName, XMLElement rule) {
        switch (rule.tag()) {
            case "indent": {
                return this.handleIndent(ruleName, rule, false, true);
            }
            case "indent-one": {
                return this.handleIndent(ruleName, rule, true, false);
            }
            case "indent-non-zero": {
                return this.handleIndent(ruleName, rule, false, false);
            }
            case "many": {
                return this.handleMany(ruleName, rule, true);
            }
            case "one-or-more": {
                return this.handleMany(ruleName, rule, false);
            }
            case "optional": {
                return this.handleOptional(ruleName, rule);
            }
            case "ref": {
                return this.handleRef(ruleName, rule);
            }
            case "seq": {
                return this.handleSeq(ruleName, rule);
            }
            case "token": {
                return this.handleToken(ruleName, rule);
            }
            case "eol": {
                return this.generateEOL(ruleName, rule);
            }
            case "will-name": {
                return this.handleWillName(ruleName, rule);
            }
            case "nested-name": {
                return this.handleNestedName(ruleName, rule);
            }
            case "push-part": {
                return this.handlePushPart(ruleName, rule);
            }
            case "dict": {
                return this.dictSet(ruleName, rule);
            }
            case "dict-clear": {
                return this.dictClear(ruleName, rule);
            }
            case "cond": {
                return this.cond(ruleName, rule);
            }
            case "can-repeat-with-case-number": {
                return this.handleCaseNumbering(ruleName, rule);
            }
            case "reduces-as": {
                return this.reducesAs(ruleName, rule);
            }
        }
        throw new RuntimeException("Production '" + ruleName + "' references unknown operation " + rule.tag());
    }

    private IndentDefinition handleIndent(String ruleName, XMLElement rule, boolean exactlyOne, boolean allowZero) {
        rule.attributesDone();
        Definition defn = this.parseDefn(ruleName, rule.uniqueElement("ref"));
        IndentDefinition ret = new IndentDefinition(defn, exactlyOne, allowZero);
        List ras = rule.elementChildren("reduces-as");
        if (!ras.isEmpty()) {
            ReducesAs reducesAs = (ReducesAs)this.parseDefn(ruleName, (XMLElement)ras.get(0));
            ret.reducesAs(reducesAs.ruleName);
        }
        return ret;
    }

    private ManyDefinition handleMany(String ruleName, XMLElement rule, boolean allowZero) {
        Definition defn;
        String shared = rule.optional("shared");
        if (!rule.elementChildren("ref").isEmpty()) {
            defn = this.parseDefn(ruleName, rule.uniqueElement("ref"));
        } else if (!rule.elementChildren("token").isEmpty()) {
            defn = this.parseDefn(ruleName, rule.uniqueElement("token"));
        } else {
            throw new CantHappenException("there is no 'ref' or 'token' element in Many");
        }
        rule.attributesDone();
        return new ManyDefinition(defn, allowZero, shared);
    }

    private Definition handleOptional(String ruleName, XMLElement rule) {
        Definition defn;
        if (!rule.elementChildren("token").isEmpty()) {
            defn = this.parseDefn(ruleName, rule.uniqueElement("token"));
        } else if (!rule.elementChildren("ref").isEmpty()) {
            defn = this.parseDefn(ruleName, rule.uniqueElement("ref"));
        } else if (!rule.elementChildren("or").isEmpty()) {
            defn = this.parseDefn(ruleName, rule.uniqueElement("or"));
        } else {
            throw new NotImplementedException("Cannot find something useful to use in optional " + rule);
        }
        String var = rule.optional("var");
        String ne = rule.optional("ne");
        rule.attributesDone();
        ElseClause elseClause = null;
        if (!rule.elementChildren("reduces-as").isEmpty()) {
            XMLElement era = rule.uniqueElement("reduces-as");
            String elseRuleName = era.required("rule");
            era.attributesDone();
            elseClause = new ElseClause(elseRuleName);
        }
        return new OptionalDefinition(defn, elseClause, var, ne);
    }

    private Definition handleRef(String ruleName, XMLElement rule) {
        String child = rule.required("production");
        boolean resetToken = rule.optionalBoolean("reset-current-token", false);
        int from = rule.optionalInt("from", 0);
        int to = rule.optionalInt("to", Integer.MAX_VALUE);
        rule.attributesDone();
        return new RefDefinition(child, resetToken, from, to);
    }

    private Definition handleSeq(String ruleName, XMLElement rule) {
        SequenceDefinition ret = new SequenceDefinition();
        ret.borrowFinalIndent(rule.optionalBoolean("borrow-final-indent", false));
        rule.attributesDone();
        for (XMLElement xe : rule.elementChildren()) {
            ret.add(this.parseDefn(ruleName, xe));
        }
        return ret;
    }

    private TokenDefinition handleToken(String ruleName, XMLElement rule) {
        String type = rule.required("type");
        String nameAppender = rule.optional("names");
        String scope = rule.optional("scope", null);
        String generator = rule.optional("generator", null);
        boolean space = rule.optionalBoolean("space", true);
        SentenceProducer.UseNameForScoping unfs = SentenceProducer.UseNameForScoping.UNSCOPED;
        if ("true".equals(scope)) {
            unfs = SentenceProducer.UseNameForScoping.USE_THIS_NAME;
        } else if ("false".equals(scope)) {
            unfs = SentenceProducer.UseNameForScoping.USE_CURRENT_NAME;
        } else if ("indent".equals(scope)) {
            unfs = SentenceProducer.UseNameForScoping.INDENT_THIS_ONCE;
        }
        boolean repeatLast = rule.optionalBoolean("maybe-repeat-last", false);
        boolean saveLast = rule.optionalBoolean("save-last", false);
        rule.attributesDone();
        TokenDefinition ret = new TokenDefinition(type, nameAppender, unfs, repeatLast, saveLast, generator, space);
        List matchers = rule.elementChildren("named");
        for (XMLElement xe : matchers) {
            String amendedName = xe.required("amended");
            String pattern = xe.optional("pattern");
            boolean scoper = xe.optionalBoolean("scope", false);
            ret.addMatcher(amendedName, pattern, scoper ? SentenceProducer.UseNameForScoping.USE_THIS_NAME : SentenceProducer.UseNameForScoping.USE_CURRENT_NAME);
            xe.attributesDone();
        }
        List useMatchers = rule.elementChildren("use-name");
        for (XMLElement xe : useMatchers) {
            xe.attributesDone();
            ret.addMatcher(null, null, SentenceProducer.UseNameForScoping.UNSCOPED);
        }
        return ret;
    }

    private GenerateEOL generateEOL(String ruleName, XMLElement rule) {
        rule.attributesDone();
        GenerateEOL ret = new GenerateEOL();
        return ret;
    }

    private Definition handleWillName(String ruleName, XMLElement rule) {
        String amend = rule.optional("amended", null);
        String pattern = rule.required("pattern");
        rule.attributesDone();
        return new WillNameDefinition(amend, pattern);
    }

    private Definition handleNestedName(String ruleName, XMLElement rule) {
        int offset = rule.requiredInt("offset");
        rule.attributesDone();
        return new NestedNameDefinition(offset);
    }

    private Definition handlePushPart(String ruleName, XMLElement rule) {
        String prefix = rule.optional("prefix");
        String names = rule.optional("names");
        boolean appendFileName = rule.optionalBoolean("filename", false);
        rule.attributesDone();
        return new PushPartDefinition(prefix, names, appendFileName);
    }

    private Definition handleCaseNumbering(String ruleName, XMLElement rule) {
        rule.attributesDone();
        return new CaseNumberingDefinition();
    }

    private Definition dictSet(String ruleName, XMLElement rule) {
        String var = rule.required("var");
        String val = rule.required("val");
        rule.attributesDone();
        return new DictSetDefinition(var, val);
    }

    private Definition dictClear(String ruleName, XMLElement rule) {
        String var = rule.required("var");
        rule.attributesDone();
        return new DictClearDefinition(var);
    }

    private Definition cond(String ruleName, XMLElement rule) {
        String var = rule.required("var");
        String ne = rule.optional("ne");
        String notset = rule.optional("notset");
        rule.attributesDone();
        if (rule.elementChildren().size() != 1) {
            throw new RuntimeException("cond needs 1 child, not " + rule.elementChildren().size());
        }
        return new CondDefinition(var, ne, Boolean.parseBoolean(notset), this.parseDefn(ruleName, (XMLElement)rule.elementChildren().get(0)));
    }

    private Definition reducesAs(String ruleName, XMLElement rule) {
        String reducesAs = rule.required("rule");
        String base = rule.optional("base");
        rule.attributesDone();
        return new ReducesAs(reducesAs, base);
    }

    public Iterable<Section> sections() {
        return this.sections.values();
    }

    public Iterable<Production> productions() {
        return this.productions.values();
    }

    public String top() {
        return this.productions.values().iterator().next().name;
    }

    public Production findRule(String name) {
        Production ret = this.productions.get(name);
        if (ret == null) {
            throw new RuntimeException("Could not find production for " + name);
        }
        return ret;
    }

    public Set<String> allProductions() {
        return this.productions.keySet();
    }

    public Set<String> allProductionCases() {
        TreeSet<String> ret = new TreeSet<String>(new RuleComparator());
        for (Production p : this.productions.values()) {
            if (p instanceof OrProduction) {
                for (int i = 0; i < ((OrProduction)p).size(); ++i) {
                    ret.add(p.ruleNumber() + "." + (i + 1) + " " + p.ruleName());
                }
                continue;
            }
            ret.add(p.ruleNumber() + " " + p.ruleName());
        }
        return ret;
    }

    public Set<String> allReferences() {
        TreeSet<String> ret = new TreeSet<String>();
        for (Production p : this.productions.values()) {
            p.collectReferences(ret);
        }
        return ret;
    }

    public Set<String> lexTokens() {
        TreeSet<String> ret = new TreeSet<String>();
        for (Lexer l : this.lexers) {
            ret.add(l.token);
        }
        return ret;
    }

    public Set<String> tokenUsages() {
        TreeSet<String> ret = new TreeSet<String>();
        for (Production p : this.productions.values()) {
            p.collectTokens(ret);
        }
        return ret;
    }

    public Set<Lexer> lexers() {
        return this.lexers;
    }

    public Lexer findToken(String token) {
        for (Lexer l : this.lexers) {
            if (!l.token.equals(token)) continue;
            return l;
        }
        throw new RuntimeException("There is no token " + token);
    }

    public List<CSSFile> cssFiles() {
        return this.cssFiles;
    }

    public List<String> jsFiles() {
        return this.jsFiles;
    }

    public String substituteRuleVars(String desc) {
        StringBuilder sb = new StringBuilder(desc);
        int from = 0;
        while ((from = sb.indexOf("${", from)) != -1) {
            int to = sb.indexOf("}", from);
            if (to == -1) {
                throw new RuntimeException("Mismatched rule reference" + sb.substring(from));
            }
            String name = sb.substring(from + 2, to);
            if (!this.productions.containsKey(name)) {
                throw new RuntimeException("Cannot reference ${" + name + "}");
            }
            Iterator<String> it = this.productions.keySet().iterator();
            int i = 1;
            while (it.hasNext()) {
                if (it.next().equals(name)) {
                    sb.replace(from, to + 1, "(" + i + ")");
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static class RuleComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            return Float.compare(this.parse(o1), this.parse(o2));
        }

        private float parse(String o2) {
            int idx = o2.indexOf(32);
            return Float.parseFloat(o2.substring(0, idx));
        }
    }
}

