/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.grammar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.flasck.flas.grammar.CSSFile;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.Lexer;
import org.flasck.flas.grammar.Production;
import org.flasck.flas.grammar.Section;

public class Generator {
    private final File html;

    public Generator(File out) {
        this.html = new File(out, "grammar.html");
    }

    public void generateGrammarHTML(Grammar grammar) throws FileNotFoundException {
        PrintWriter str = new PrintWriter(new FileOutputStream(this.html));
        this.generateHead(grammar, str);
        str.println("<div class='whole-window'>");
        this.generateHamburger(grammar, str);
        str.println("<div class='grammar-content'>");
        this.generateLexical(grammar, str);
        this.generateSummary(grammar, str);
        this.generateDefinitionSections(grammar, str);
        str.println("</div>");
        str.println("</div>");
        this.generateTail(str);
        str.close();
    }

    private void generateHead(Grammar grammar, PrintWriter str) {
        str.println("<!DOCTYPE html>");
        str.println("<html>");
        str.println("<head>");
        str.println("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
        str.println("<title>" + StringEscapeUtils.escapeHtml4((String)grammar.title) + "</title>");
        for (CSSFile css : grammar.cssFiles()) {
            Object mtype = "";
            if (css.media != null) {
                mtype = " media='" + css.media + "'";
            }
            str.println("<link type='text/css' rel='stylesheet' href='" + StringEscapeUtils.escapeHtml4((String)css.href) + "'" + (String)mtype + ">");
        }
        for (String js : grammar.jsFiles()) {
            str.println("<script type='text/javascript' src='" + StringEscapeUtils.escapeHtml4((String)js) + "'></script>");
        }
        str.println("</head>");
        str.println("<body>");
    }

    private void generateHamburger(Grammar grammar, PrintWriter str) {
        str.println("<div class='hamburger-div'>");
        str.println("<div class='hamburger-icon'></div>");
        str.println("</div>");
        str.println("<div class='hamburger-menu'>");
        for (Section s : grammar.sections()) {
            str.println("<div class='hamburger-section-link' data-grammar-section='" + s.title + "'>");
            str.println(s.title);
            str.println("</div>");
        }
        str.println("<div class='hamburger-section-link' data-grammar-section='lexical-issues'>");
        str.println("Lexing");
        str.println("</div>");
        str.println("<div class='hamburger-section-link' data-grammar-section='grammar-summary'>");
        str.println("Summary");
        str.println("</div>");
        str.println("</div>");
    }

    private void generateLexical(Grammar grammar, PrintWriter str) {
        str.println("<div class='grammar-section' data-grammar-section='lexical-issues'>");
        str.println("<h3>Lexical Issues</h3>");
        for (Lexer l : grammar.lexers()) {
            str.print("<h3>" + StringEscapeUtils.escapeHtml4((String)l.token) + "</h3>");
            str.print("<span class='pattern-title'>Pattern:</span><span class='pattern'>" + StringEscapeUtils.escapeHtml4((String)l.pattern) + "</span>");
            str.print("<div class='lexical-description'>");
            str.print(l.desc);
            str.print("</div>");
        }
        str.println("</div>");
    }

    private void generateSummary(Grammar grammar, PrintWriter str) {
        str.println("<div class='grammar-section' data-grammar-section='grammar-summary'>");
        str.println("<h3>Summary</h3>");
        for (Production p : grammar.productions()) {
            p.show(str, false);
        }
        str.println("</div>");
    }

    private void generateDefinitionSections(Grammar grammar, PrintWriter str) {
        for (Section s : grammar.sections()) {
            str.println("<div class='grammar-section' data-grammar-section='" + s.title + "'>");
            str.println("<h3>" + StringEscapeUtils.escapeHtml4((String)s.title) + "</h3>");
            str.println("<div class='section-description'>");
            str.print(grammar.substituteRuleVars(s.desc));
            str.println("</div>");
            for (Production p : s.productions()) {
                p.show(str, true);
            }
            str.println("</div>");
        }
    }

    private void generateTail(PrintWriter str) {
        str.print("</body>\n");
        str.print("</html>\n");
    }
}

