/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.errors;

import java.io.File;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.FLASError;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class LocalErrorTracker
implements ErrorReporter {
    private final ErrorReporter other;
    boolean seenLocalErrors = false;
    private Set<AtomicBoolean> marks = new HashSet<AtomicBoolean>();

    public LocalErrorTracker(ErrorReporter other) {
        this.other = other;
    }

    @Override
    public void showFromMark(ErrorMark mark, Writer pw, int ind) {
        this.other.showFromMark(mark, pw, ind);
    }

    @Override
    public ErrorReporter message(InputPosition pos, String msg) {
        this.seenErrors();
        return this.other.message(pos, msg);
    }

    @Override
    public ErrorReporter message(InputPosition pos, Collection<InputPosition> locs, String msg) {
        this.seenErrors();
        return this.other.message(pos, locs, msg);
    }

    @Override
    public ErrorReporter message(Tokenizable line, String msg) {
        this.seenErrors();
        return this.other.message(line, msg);
    }

    @Override
    public ErrorReporter message(FLASError e) {
        this.seenErrors();
        return this.other.message(e);
    }

    public void seenErrors() {
        this.seenLocalErrors = true;
        for (AtomicBoolean b : this.marks) {
            b.set(true);
        }
    }

    @Override
    public ErrorReporter reportException(Throwable ex) {
        this.seenErrors();
        return this.other.reportException(ex);
    }

    public void fakeErrorWithoutNeedingAssertion() {
        this.seenErrors();
    }

    @Override
    public boolean hasErrors() {
        return this.seenLocalErrors;
    }

    @Override
    public ErrorMark mark() {
        final AtomicBoolean ab = new AtomicBoolean(false);
        this.marks.add(ab);
        return new ErrorMark(){

            @Override
            public boolean hasMoreNow() {
                return ab.get();
            }
        };
    }

    @Override
    public void track(File f) {
        this.other.track(f);
    }

    @Override
    public <T extends LoggableToken> T logParsingToken(T token) {
        return this.other.logParsingToken(token);
    }

    @Override
    public void logReduction(String ruleId, Locatable from, Locatable to) {
        this.logReduction(ruleId, from.location(), to.location());
    }

    @Override
    public void logReduction(String ruleId, InputPosition from, InputPosition to) {
        this.other.logReduction(ruleId, from, to);
    }
}

