/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.errors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.FLASError;
import org.flasck.flas.errors.FatErrorAPI;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.FreeTextToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.utils.Justification;

public class ErrorResult
extends FatErrorAPI
implements ErrorReporter,
Iterable<FLASError> {
    public static final Logger logger = LoggerFactory.getLogger((String)"ErrorResult");
    private final Set<FLASError> errors = new TreeSet<FLASError>();
    private final File saveParsingTokens;
    private PrintWriter tokenStream;

    public ErrorResult() {
        this(null);
    }

    public ErrorResult(File saveParsingTokens) {
        this.saveParsingTokens = saveParsingTokens;
    }

    public int count() {
        return this.errors.size();
    }

    @Override
    public ErrorResult message(FLASError e) {
        this.errors.add(e);
        return this;
    }

    public void merge(ErrorReporter from) {
        this.errors.addAll(((ErrorResult)from).errors);
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean moreErrors(int mark) {
        return this.errors.size() > mark;
    }

    public FLASError get(int i) {
        return (FLASError)CollectionUtils.nth(this.errors, (int)i);
    }

    @Override
    public void showFromMark(ErrorMark em, Writer pw, int ind) {
        Marker mark = (Marker)em;
        if (em == null) {
            mark = new Marker(true);
        }
        try {
            for (FLASError e : this.errors) {
                if (mark.contains(e)) continue;
                for (int i = 0; i < ind; ++i) {
                    pw.append(' ');
                }
                InputPosition l = e.loc;
                if (l != null) {
                    this.showLine(pw, ind, l);
                }
                for (InputPosition li : e.others) {
                    this.showLine(pw, ind, li);
                }
                pw.write(Justification.PADRIGHT.format("", 26));
                pw.write(e.msg);
                pw.write(10);
            }
            pw.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void showLine(Writer pw, int ind, InputPosition l) throws IOException {
        pw.write(Justification.PADRIGHT.format(l + ": ", 22) + (String)(l.text == null ? "" : l.text.substring(0, l.off) + " _ " + l.text.substring(l.off)));
        pw.write(10);
        for (int i = 0; i < ind; ++i) {
            pw.append(' ');
        }
    }

    public void showTo(Writer pw, int ind) throws IOException {
        this.showFromMark(new Marker(false), pw, ind);
    }

    @Override
    public ErrorMark mark() {
        return new Marker(true);
    }

    public String singleString() throws IOException {
        StringWriter w = new StringWriter();
        this.showTo(w, 0);
        return ((Object)w).toString();
    }

    public String toString() {
        try {
            return "ErrorResult[" + this.singleString() + "]";
        }
        catch (IOException ex) {
            return ex.toString();
        }
    }

    @Override
    public Iterator<FLASError> iterator() {
        return this.errors.iterator();
    }

    @Override
    public void track(File f) {
        System.out.println("    " + f.getName());
        if (this.tokenStream != null) {
            this.tokenStream.close();
            this.tokenStream = null;
        }
        try {
            if (this.saveParsingTokens != null) {
                this.tokenStream = new PrintWriter(new File(this.saveParsingTokens, f.getName()));
            }
        }
        catch (FileNotFoundException ex) {
            System.err.println("could not open " + this.saveParsingTokens);
            this.tokenStream = null;
        }
    }

    @Override
    public <T extends LoggableToken> T logParsingToken(T token) {
        if (this.tokenStream != null) {
            if (token instanceof FreeTextToken) {
                for (FreeTextToken t : ((FreeTextToken)token).original) {
                    this.logLocation(t.location());
                    this.tokenStream.println("token " + t.type() + " " + t.text());
                }
            } else {
                this.logLocation(token.location());
                this.tokenStream.println("token " + token.type() + " " + token.text());
            }
        }
        return token;
    }

    @Override
    public void logReduction(String ruleId, Locatable from, Locatable to) {
        this.logReduction(ruleId, from.location(), to.location());
    }

    @Override
    public void logReduction(String ruleId, InputPosition from, InputPosition to) {
        logger.info("reducing " + ruleId + " from " + from + " - " + to);
        if (this.tokenStream != null) {
            this.logLocation(from);
            this.tokenStream.println("reduction " + ruleId);
            this.logLocation(to);
        }
    }

    private void logLocation(InputPosition pos) {
        this.tokenStream.print(pos.lineNo + ":");
        if (pos.indent != null) {
            this.tokenStream.print(pos.indent.tabs + "." + pos.indent.spaces);
        } else {
            this.tokenStream.print("0.0");
        }
        this.tokenStream.println(":" + pos.off);
    }

    public void closeTokenStream() {
        if (this.tokenStream != null) {
            this.tokenStream.close();
        }
    }

    private class Marker
    implements ErrorMark {
        private Set<FLASError> have = new TreeSet<FLASError>();

        public Marker(boolean includeCurrent) {
            if (includeCurrent) {
                for (FLASError e : ErrorResult.this.errors) {
                    this.have.add(e);
                }
            }
        }

        @Override
        public boolean hasMoreNow() {
            return ErrorResult.this.count() > this.have.size();
        }

        public boolean contains(FLASError e) {
            return this.have.contains(e);
        }
    }
}

