/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.doc.grammar;

import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.flas.Main;
import org.flasck.flas.doc.grammar.GenerateRegressionSuite;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.RepoChecker;
import org.junit.Assert;
import org.junit.Test;
import org.zinutils.collections.CounterSet;
import org.zinutils.utils.FileUtils;

public class RunRegressionSuite {
    final File root = new File("src/regression");

    @Test
    public void testAll() throws Throwable {
        boolean runMe = Boolean.parseBoolean(System.getProperty("doc.grammar.run"));
        if (!runMe) {
            return;
        }
        GenerateRegressionSuite.generateInto(this.root);
        List dirs = FileUtils.findDirectoriesUnder((File)this.root);
        File meta = new File(this.root, "META.json");
        JSONObject jo = new JSONObject(FileUtils.readFile((File)meta));
        TreeSet<String> passed = new TreeSet<String>();
        TreeSet<String> failed = new TreeSet<String>();
        CounterSet success = new CounterSet();
        CounterSet failure = new CounterSet();
        String onlyRun = System.getProperty("doc.grammar.onlyrun");
        if (onlyRun != null) {
            dirs.clear();
            dirs.add(new File("test.r" + onlyRun));
        }
        for (File f : dirs) {
            CounterSet mycase;
            boolean result = this.runCase(f, jo.getJSONObject(f.getName()));
            if (result) {
                passed.add(f.getName());
                mycase = success;
            } else {
                failed.add(f.getName());
                mycase = failure;
            }
            JSONObject thisCase = jo.getJSONObject(f.getName());
            JSONArray rules = thisCase.getJSONArray("used");
            for (int i = 0; i < rules.length(); ++i) {
                mycase.add((Object)rules.getString(i));
            }
        }
        TreeSet<String> allKeys = new TreeSet<String>(new Grammar.RuleComparator());
        Iterator it = jo.keys();
        while (it.hasNext()) {
            JSONObject obj = jo.getJSONObject((String)it.next());
            JSONArray tmp = obj.getJSONArray("used");
            for (int i = 0; i < tmp.length(); ++i) {
                allKeys.add(tmp.getString(i));
            }
        }
        if (!failed.isEmpty()) {
            Iterator obj = allKeys.iterator();
            while (obj.hasNext()) {
                int no;
                int yes;
                String s;
                System.out.println(s + " " + yes + " " + no + " = " + (Serializable)((yes = success.getCount((Object)(s = (String)obj.next()))) + (no = failure.getCount((Object)s)) == 0 ? "--" : Integer.valueOf(100 * yes / (yes + no))) + "%");
            }
            meta.delete();
        }
        Assert.assertEquals((String)"Not all regression tests were run", (long)dirs.size(), (long)(passed.size() + failed.size()));
        System.out.println("Ran " + dirs.size() + " - " + passed.size() + " passed; " + failed.size() + " failed");
        Iterator it2 = failed.iterator();
        for (int i = 0; it2.hasNext() && i < 10; ++i) {
            System.out.println("failed: " + (String)it2.next());
        }
        Assert.assertTrue((String)(failed.size() + " of " + dirs.size() + " regression tests failed"), (boolean)failed.isEmpty());
    }

    public boolean runCase(File f, JSONObject jo) throws JSONException {
        boolean result;
        JSONObject ms = jo.getJSONObject("matchers");
        File dir = FileUtils.combine((File)this.root, (File)f);
        try {
            File repoFile = File.createTempFile("repo", ".txt");
            boolean bl = result = !Main.standardCompiler(null, "--phase", "PARSING", "--capture-repository", repoFile.getPath(), dir.toString());
            if (result) {
                result = RepoChecker.checkRepo(repoFile, this.asMap(ms));
            }
        }
        catch (Exception ex) {
            result = false;
        }
        if (!result) {
            for (File fl : FileUtils.findFilesMatching((File)dir, (String)"*.fl")) {
                System.out.println(fl + ":");
                FileUtils.cat((File)fl);
            }
            for (File ut : FileUtils.findFilesMatching((File)dir, (String)"*.ut")) {
                System.out.println(ut + ":");
                FileUtils.cat((File)ut);
            }
        }
        return result;
    }

    private Map<String, String> asMap(JSONObject ms) throws JSONException {
        Iterator it = ms.keys();
        TreeMap<String, String> ret = new TreeMap<String, String>();
        while (it.hasNext()) {
            String s = (String)it.next();
            ret.put(s, ms.getString(s));
        }
        return ret;
    }
}

