/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.doc.grammar;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.flasck.flas.Main;
import org.flasck.flas.grammar.RepoChecker;
import org.flasck.flas.grammar.SentenceData;
import org.flasck.flas.grammar.SentenceProducer;
import org.junit.Assert;
import org.junit.Test;
import org.zinutils.utils.FileUtils;

public class RandomSentenceTest {
    @Test
    public void testRandomSentenceProduction() throws Throwable {
        int seed = 22512;
        File td = Files.createTempDirectory("flas", new FileAttribute[0]).toFile();
        File fd = new File(td, "test.r22512");
        FileUtils.assertDirectory((File)fd);
        File repoFile = File.createTempFile("repo", ".txt");
        SentenceProducer p = new SentenceProducer(fd, "/gh-grammar/grammar.xml");
        AtomicBoolean failed = new AtomicBoolean(false);
        TreeMap<String, String> matchers = new TreeMap<String, String>();
        Consumer<SentenceData> collector = used -> matchers.putAll(used.matchers);
        p.sentence(22512L, "source-file", collector);
        p.sentence(22512L, "unit-test-file", collector);
        p.sentence(22512L, "system-test-file", collector);
        File fl = new File(fd, "test.r22512/r22512.fl");
        System.out.println(fl + ":");
        FileUtils.cat((File)fl);
        File ut = new File(fd, "test.r22512/r22512.ut");
        System.out.println(ut + ":");
        FileUtils.cat((File)ut);
        File st = new File(fd, "test.r22512/r22512.st");
        System.out.println(st + ":");
        FileUtils.cat((File)st);
        try {
            boolean f = Main.standardCompiler(null, "--phase", "PARSING", "--capture-repository", repoFile.getPath(), fd.toString());
            if (!f) {
                if (!RepoChecker.checkRepo(repoFile, matchers)) {
                    failed.set(true);
                }
            } else {
                System.out.println("Compilation failed");
                failed.set(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            failed.set(true);
        }
        FileUtils.deleteDirectoryTree((File)td);
        repoFile.delete();
        if (failed.get() && fd.listFiles() != null) {
            for (File f : fd.listFiles()) {
                if (!f.isFile()) continue;
                FileUtils.cat((File)f);
            }
        }
        Assert.assertFalse((boolean)failed.get());
    }
}

