/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.doc.grammar;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.SentenceData;
import org.flasck.flas.grammar.SentenceProducer;
import org.junit.Assert;
import org.zinutils.utils.FileUtils;
import org.zinutils.xml.XML;

public class GenerateRegressionSuite {
    static final String grammar = "/gh-grammar/grammar.xml";

    public static void main(String[] args) throws Throwable {
        File top = new File("src/regression");
        FileUtils.deleteDirectoryTree((File)top);
        File meta = GenerateRegressionSuite.generateInto(top);
        FileUtils.cat((File)meta);
    }

    public static File generateInto(File top) throws Throwable {
        URL gm;
        File gf;
        File meta = new File(top, "META.json");
        if (meta.exists() && (gf = new File((gm = XML.class.getResource(grammar)).getFile())).lastModified() < meta.lastModified()) {
            System.out.println("not regenerating grammar.xml because it has not changed");
            System.out.println("remove " + meta + " to force regeneration");
            return meta;
        }
        JSONObject jo = new JSONObject();
        TreeSet<String> allUsed = new TreeSet<String>(new Grammar.RuleComparator());
        for (long i = 21000L; i < 29000L; i += 7L) {
            long j = i;
            SentenceProducer p = new SentenceProducer(top, grammar);
            Consumer<SentenceData> store = used -> GenerateRegressionSuite.store(allUsed, jo, "test.r" + Long.toString(j), used);
            p.sentence(i, "source-file", store);
            p.sentence(i, "unit-test-file", store);
            p.sentence(i, "system-test-file", store);
        }
        Set<String> allProds = Grammar.from(XML.fromResource((String)grammar)).allProductionCases();
        GenerateRegressionSuite.removeOnesWeKnowWeDontTestYet(allProds);
        allProds.removeAll(allUsed);
        Assert.assertTrue((String)("Productions not used: " + allProds), (boolean)allProds.isEmpty());
        FileUtils.writeFile((File)meta, (String)jo.toString());
        return meta;
    }

    private static void removeOnesWeKnowWeDontTestYet(Set<String> allProds) {
        int removed = 0;
        Iterator<String> it = allProds.iterator();
        while (it.hasNext()) {
            String prod = it.next();
            if (!prod.endsWith(" file") && !prod.endsWith(" assembly-file") && !prod.endsWith(" assembly-unit") && !prod.endsWith(" protocol-test-file") && !prod.endsWith(" protocol-test-unit")) continue;
            it.remove();
            ++removed;
        }
        Assert.assertEquals((long)9L, (long)removed);
    }

    private static void store(Set<String> allUsed, JSONObject jo, String key, SentenceData used) {
        try {
            allUsed.addAll(used.productionsUsed);
            TreeSet<String> now = new TreeSet<String>();
            TreeMap<String, String> nowms = new TreeMap<String, String>();
            if (jo.has(key)) {
                JSONObject curr = jo.getJSONObject(key);
                GenerateRegressionSuite.addAll(now, curr.getJSONArray("used"));
                GenerateRegressionSuite.putAll(nowms, curr.getJSONObject("matchers"));
            }
            now.addAll(used.productionsUsed);
            nowms.putAll(used.matchers);
            JSONObject thisOne = new JSONObject();
            thisOne.put("used", now);
            thisOne.put("matchers", nowms);
            jo.put(key, (Object)thisOne);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void addAll(TreeSet<String> now, JSONArray ja) throws JSONException {
        for (int i = 0; i < ja.length(); ++i) {
            now.add(ja.getString(i));
        }
    }

    private static void putAll(TreeMap<String, String> nowms, JSONObject jo) throws JSONException {
        Iterator it = jo.keys();
        while (it.hasNext()) {
            String s = (String)it.next();
            nowms.put(s, jo.getString(s));
        }
    }
}

