/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.doc.grammar;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.flas.grammar.Generator;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.GrammarSupport;
import org.junit.Assert;
import org.junit.Test;
import org.zinutils.utils.FileUtils;

public class GenerateGrammarDoc {
    @Test
    public void generateAllTheGrammarPages() throws FileNotFoundException {
        String gd = System.getenv("FLAS_GRAMMAR_DIR");
        if (gd == null) {
            gd = System.getProperty("org.ziniki.flas_grammar_dir");
        }
        if (gd == null) {
            System.out.println("There is no env var FLAS_GRAMMAR_DIR or -Dorg.ziniki.flas_grammar_dir to store the output");
            return;
        }
        File out = new File(gd);
        for (File f : FileUtils.findFilesMatching((File)GrammarSupport.srcDir(), (String)"*.css")) {
            FileUtils.copy((File)f, (File)out);
        }
        for (File f : FileUtils.findFilesMatching((File)GrammarSupport.srcDir(), (String)"*.js")) {
            FileUtils.copy((File)f, (File)out);
        }
        Grammar grammar = GrammarSupport.loadGrammar();
        Generator gen = new Generator(out);
        gen.generateGrammarHTML(grammar);
        GenerateGrammarDoc.checkTokens(grammar);
        GenerateGrammarDoc.checkProductions(grammar);
    }

    public static void checkTokens(Grammar grammar) {
        Set<String> prods = grammar.lexTokens();
        Set<String> refs = grammar.tokenUsages();
        TreeSet<String> unused = new TreeSet<String>(prods);
        unused.remove(grammar.top());
        unused.removeAll(refs);
        refs.removeAll(prods);
        Assert.assertEquals((String)"unused tokens", new TreeSet(), unused);
        Assert.assertEquals((String)"undefined tokens", new TreeSet(), refs);
    }

    public static void checkProductions(Grammar grammar) {
        Set<String> prods = grammar.allProductions();
        Set<String> refs = grammar.allReferences();
        TreeSet<String> unused = new TreeSet<String>(prods);
        unused.remove(grammar.top());
        unused.removeAll(refs);
        refs.removeAll(prods);
        Assert.assertEquals((String)"unused productions", new TreeSet(), unused);
        Assert.assertEquals((String)"undefined productions", new TreeSet(), refs);
    }
}

