/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.templates;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flasck.flas.compiler.templates.EventPlacement;
import org.flasck.flas.compiler.templates.EventTargetZones;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.EventHolder;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateEvent;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.StackVisitor;

public class EventBuilder
extends LeafAdapter {
    private final Map<EventHolder, EventTargetZones> eventMap;
    private EventPlacement currentETZ;
    private String templateId;
    private TemplateBinding currentBinding;
    private int option = 0;
    private int cond = 0;
    private List<Integer> conds = new ArrayList<Integer>();

    public EventBuilder(StackVisitor stack, Map<EventHolder, EventTargetZones> etz) {
        this.eventMap = etz;
        stack.push(this);
    }

    @Override
    public void visitCardDefn(CardDefinition cd) {
        this.currentETZ = new EventPlacement();
        this.eventMap.put(cd, this.currentETZ);
    }

    @Override
    public void visitObjectDefn(ObjectDefn od) {
        this.currentETZ = new EventPlacement();
        this.eventMap.put(od, this.currentETZ);
    }

    @Override
    public void visitObjectMethod(ObjectMethod meth) {
        if (meth.isEvent()) {
            TypedPattern tp = (TypedPattern)meth.args().get(0);
            this.eventMap.get(meth.getCard()).handler(tp.type.name(), meth.name());
        }
    }

    @Override
    public void visitTemplate(Template t, boolean isFirst) {
        this.templateId = t.webinfo().id();
        this.cond = 0;
    }

    @Override
    public void visitTemplateBinding(TemplateBinding b) {
        this.currentBinding = b;
        this.option = 0;
        this.cond = 0;
    }

    @Override
    public void visitTemplateBindingOption(TemplateBindingOption tbo) {
        ++this.option;
    }

    @Override
    public void visitTemplateStyling(TemplateStylingOption tso) {
        if (tso.cond != null) {
            this.conds.add(this.cond);
            ++this.cond;
        }
    }

    @Override
    public void leaveTemplateStyling(TemplateStylingOption tso) {
        if (tso.cond != null) {
            this.conds.remove(this.conds.size() - 1);
        }
    }

    @Override
    public void visitTemplateEvent(TemplateEvent te) {
        Integer cond = null;
        if (!this.conds.isEmpty()) {
            cond = this.conds.get(this.conds.size() - 1);
        }
        this.currentETZ.binding(this.templateId, this.currentBinding, this.option, te.handler, cond);
    }

    @Override
    public void leaveTemplateBinding(TemplateBinding b) {
        this.currentBinding = null;
    }

    @Override
    public void leaveTemplate(Template t) {
        this.templateId = null;
    }

    @Override
    public void leaveCardDefn(CardDefinition s) {
        this.currentETZ = null;
    }

    @Override
    public void leaveObjectDefn(ObjectDefn od) {
        this.currentETZ = null;
    }
}

