/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.packaging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.flas.Configuration;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.jsgen.creators.JSClass;
import org.flasck.flas.compiler.jsgen.creators.JSClassCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethod;
import org.flasck.flas.compiler.jsgen.packaging.ApplRoutingTable;
import org.flasck.flas.compiler.jsgen.packaging.EventMap;
import org.flasck.flas.compiler.jsgen.packaging.JSUploader;
import org.flasck.flas.compiler.jsgen.packaging.MethodList;
import org.flasck.flas.compiler.templates.EventTargetZones;
import org.flasck.flas.parsedForm.assembly.ApplicationRouting;
import org.flasck.flas.repository.Repository;
import org.flasck.jvm.ziniki.ContentObject;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.collections.ListMap;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.utils.FileUtils;

public class JSFile {
    private final Repository repository;
    private final NameOfThing pkg;
    private final boolean isTest;
    private final String key;
    private final Set<String> packages = new TreeSet<String>();
    private final List<JSClass> classes = new ArrayList<JSClass>();
    private final List<JSMethod> functions = new ArrayList<JSMethod>();
    private final List<MethodList> methodLists = new ArrayList<MethodList>();
    private final List<EventMap> eventMaps = new ArrayList<EventMap>();
    private final List<ApplRoutingTable> routes = new ArrayList<ApplRoutingTable>();
    private final Set<String> exports = new TreeSet<String>();
    private ContentObject co;

    public JSFile(Repository repository, NameOfThing pkg, String name) {
        this.repository = repository;
        this.pkg = pkg;
        this.key = name;
        this.isTest = pkg.uniqueName().contains("_");
    }

    public String key() {
        return this.key;
    }

    public void ensurePackage(String nested) {
        this.packages.add(nested);
    }

    public void addClass(JSClass ret) {
        this.classes.add(ret);
    }

    public void addFunction(JSMethod jsMethod) {
        this.functions.add(jsMethod);
    }

    public void methodList(NameOfThing name, List<FunctionName> methods) {
        this.methodLists.add(new MethodList(name, methods));
    }

    public void eventMap(NameOfThing name, EventTargetZones etz) {
        this.eventMaps.add(new EventMap(name, etz));
    }

    public void applRouting(JSClassCreator clz, NameOfThing name, ApplicationRouting routes) {
        this.routes.add(new ApplRoutingTable(name, routes));
    }

    public ContentObject generate(Configuration config, Collection<String> imports) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        IndentWriter iw = new IndentWriter(pw);
        this.writeTo(iw, imports);
        pw.close();
        byte[] bs = sw.toString().getBytes();
        this.co = config.contentStore.upload(this.key, (InputStream)new ByteArrayInputStream(bs), "text/javascript", (long)bs.length, true);
        return this.co;
    }

    public void saveTo(File flimdir) {
        File f = new File(flimdir, this.co.key());
        FileUtils.copyStreamToFile((InputStream)this.co.asStream(), (File)f);
    }

    public ContentObject upload(JSUploader uploader) throws IOException {
        ContentObject ret = uploader.uploadJs(this.co);
        if (ret != null) {
            this.co = ret;
        }
        return ret;
    }

    public void writeTo(IndentWriter iw, Collection<String> imports) {
        this.declarePackages(iw);
        iw.println("import { IdempotentHandler } from \"/js/ziwsh.js\";");
        iw.println("import { Application, Assign, AssignCons, AssignItem, Debug, ResponseWithMessages, Send, UpdateDisplay, ClickEvent, ScrollTo, ContractStore, Entity, Image, Link, FLBuiltin, False, True, MakeHash, HashPair, Tuple, TypeOf, FLCard, FLObject, FLError, Nil, Cons, Crobag, CroEntry, SlideWindow, CrobagWindow, CrobagChangeEvent, CrobagWindowEvent, Random, Interval, Instant, Calendar } from \"/js/flasjs.js\";");
        if (this.isTest) {
            iw.println("import { BoundVar } from \"/js/flastest.js\";");
        }
        for (String string : imports) {
            if (string.equals(this.pkg.uniqueName())) continue;
            PackageName pn = new PackageName(string);
            if (string.equals("root.package")) {
                this.importRootPackage(iw, string, pn);
                continue;
            }
            iw.println("import { " + pn.jsName() + " } from \"/js/" + string + ".js\";");
        }
        ListMap deferred = new ListMap();
        for (JSClass c : this.classes) {
            if (c.name().container() instanceof FunctionName) {
                FunctionName functionName = (FunctionName)c.name().container();
                if (!functionName.baseName().startsWith("_")) {
                    throw new CantHappenException("was expecting a function case name");
                }
                deferred.add((Object)functionName.container().jsName(), (Object)c);
                continue;
            }
            c.writeTo(this.exports, iw);
        }
        HashSet<NameOfThing> hashSet = new HashSet<NameOfThing>();
        for (JSMethod jSMethod : this.functions) {
            this.declareContainingPackage(iw, jSMethod);
            jSMethod.write(iw, hashSet, this.exports);
            if (!deferred.contains((Object)jSMethod.jsName())) continue;
            for (JSClass c : deferred.get((Object)jSMethod.jsName())) {
                c.writeTo(this.exports, iw);
            }
        }
        for (MethodList methodList : this.methodLists) {
            methodList.write(iw);
        }
        for (EventMap eventMap : this.eventMaps) {
            eventMap.write(iw);
        }
        for (ApplRoutingTable applRoutingTable : this.routes) {
            applRoutingTable.write(iw);
        }
        this.exportPackages(iw);
    }

    private void importRootPackage(IndentWriter iw, String s, PackageName pn) {
        iw.print("import { " + pn.jsName());
        for (NameOfThing n : this.repository.rootPackageNames()) {
            iw.print(", ");
            iw.print(n.jsName());
        }
        iw.println(" } from \"/js/" + s + ".js\";");
    }

    public void generate(ByteCodeEnvironment bce) {
        for (JSClass c : this.classes) {
            c.generate(bce);
        }
        for (JSMethod f : this.functions) {
            f.generate(bce, false);
        }
        for (EventMap m : this.eventMaps) {
            m.generate(bce);
        }
        for (ApplRoutingTable r : this.routes) {
            r.generate(bce);
        }
    }

    private void declareContainingPackage(IndentWriter iw, JSMethod f) {
        Object full = f.getPackage() + "." + f.getName();
        int li = ((String)full).lastIndexOf(46);
        full = ((String)full).substring(0, li);
        for (JSClass clz : this.classes) {
            if (!clz.clzname().equals(full)) continue;
            return;
        }
        if (this.packages.contains(full)) {
            this.declarePackage(iw, (String)full);
            this.packages.remove(full);
        }
    }

    private void declarePackages(IndentWriter iw) {
        if (this.pkg == null || this.pkg.uniqueName().endsWith("_st")) {
            return;
        }
        this.declarePackage(iw, this.pkg.uniqueName());
        iw.println("");
    }

    private void declarePackage(IndentWriter iw, String full) {
        iw.print("var ");
        String exp = full.replace(".", "__");
        this.exports.add(exp);
        iw.print(exp);
        iw.println(" = {};");
    }

    private void exportPackages(IndentWriter iw) {
        if (this.exports.isEmpty()) {
            return;
        }
        iw.println("");
        iw.print("export { ");
        String sep = "";
        for (String s : this.exports) {
            iw.print(sep);
            iw.print(s);
            sep = ", ";
        }
        iw.println(" };");
    }

    public List<JSClass> classes() {
        return this.classes;
    }

    public List<JSMethod> functions() {
        return this.functions;
    }

    public void asivm() {
        for (JSClass c : this.classes) {
            System.out.println(c.asivm());
        }
        for (JSMethod m : this.functions) {
            System.out.println(m.asivm());
        }
    }

    public ContentObject co() {
        return this.co;
    }
}

