/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.Configuration;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.jsgen.creators.JSClass;
import org.flasck.flas.compiler.jsgen.creators.JSClassCreator;
import org.flasck.flas.compiler.jsgen.creators.JSMethod;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSLiteral;
import org.flasck.flas.compiler.jsgen.form.JSString;
import org.flasck.flas.compiler.jsgen.packaging.JSFile;
import org.flasck.flas.compiler.jsgen.packaging.JSStorage;
import org.flasck.flas.compiler.jsgen.packaging.JSUploader;
import org.flasck.flas.compiler.templates.EventTargetZones;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.assembly.ApplicationRouting;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.flasck.flas.repository.Repository;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.FileContentObject;
import org.flasck.jvm.ziniki.PackageSources;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.graphs.DirectedAcyclicGraph;
import org.zinutils.graphs.Node;
import org.zinutils.graphs.NodeWalker;
import org.zinutils.utils.FileUtils;

public class JSEnvironment
implements JSStorage {
    private final Repository repository;
    private final Map<String, JSFile> files = new TreeMap<String, JSFile>();
    private final List<StructDefn> structs = new ArrayList<StructDefn>();
    private final List<ContractDecl> contracts = new ArrayList<ContractDecl>();
    private final List<ObjectDefn> objects = new ArrayList<ObjectDefn>();
    private final List<HandlerImplements> handlers = new ArrayList<HandlerImplements>();
    private final DirectedAcyclicGraph<String> pkgdag;
    private final Map<String, ContentObject> gencos = new TreeMap<String, ContentObject>();
    private final List<ContentObject> localOnly = new ArrayList<ContentObject>();
    private final List<UnitTestCase> unitTests = new ArrayList<UnitTestCase>();
    private final List<SystemTest> systemTests = new ArrayList<SystemTest>();
    private final Configuration config;
    private final ErrorReporter errors;

    public JSEnvironment(Configuration config, ErrorReporter errors, Repository repository, DirectedAcyclicGraph<String> pkgs) {
        this.config = config;
        this.errors = errors;
        this.repository = repository;
        this.pkgdag = pkgs;
    }

    @Override
    public Iterable<ContentObject> files() {
        ArrayList<ContentObject> ret = new ArrayList<ContentObject>();
        Iterable pkgs = this.packageStrings();
        for (String s : pkgs) {
            JSFile f = this.files.get(s);
            if (f == null) continue;
            ret.add(f.co());
        }
        return ret;
    }

    @Override
    public ContentObject fileFor(String s) {
        JSFile r = this.files.get(s);
        if (r == null) {
            return null;
        }
        return r.co();
    }

    @Override
    public void ensurePackageExists(NameOfThing filePkg, String pkg) {
        if (filePkg == null || filePkg.uniqueName() == null) {
            filePkg = new PackageName("root.package");
        }
        if (pkg == null) {
            pkg = "root.package";
        }
        if (filePkg.jsName().equals(pkg)) {
            return;
        }
        if (!pkg.startsWith(filePkg.uniqueName()) && !pkg.startsWith(filePkg.jsName())) {
            throw new RuntimeException(pkg + " is not in " + filePkg);
        }
        this.getPackage(filePkg).ensurePackage(pkg);
    }

    @Override
    public JSClassCreator newClass(PackageName pkg, NameOfThing clz) {
        JSFile inpkg = this.getPackage(pkg);
        JSClass ret = new JSClass(this, clz);
        inpkg.addClass(ret);
        return ret;
    }

    @Override
    public JSClassCreator newUnitTest(UnitTestCase ut) {
        this.unitTests.add(ut);
        JSFile inpkg = this.getPackage(ut.name.container());
        JSClass ret = new JSClass(this, ut.name);
        inpkg.addClass(ret);
        return ret;
    }

    @Override
    public JSClassCreator newSystemTest(SystemTest st) {
        this.systemTests.add(st);
        JSFile inpkg = this.getPackage(st.name());
        JSClass ret = new JSClass(this, st.name());
        inpkg.addClass(ret);
        return ret;
    }

    @Override
    public Iterable<SystemTest> systemTests() {
        return this.systemTests;
    }

    @Override
    public Iterable<UnitTestCase> unitTests() {
        return this.unitTests;
    }

    @Override
    public JSMethodCreator newFunction(NameOfThing fnName, PackageName pkg, NameOfThing cxt, boolean isPrototype, String name) {
        JSFile inpkg = this.getPackage(pkg);
        JSMethod ret = new JSMethod(this, fnName, cxt, isPrototype, name);
        inpkg.addFunction(ret);
        return ret;
    }

    @Override
    public void methodList(NameOfThing name, List<FunctionName> methods) {
        JSFile inpkg = this.getPackage(name.packageName());
        inpkg.methodList(name, methods);
    }

    @Override
    public void eventMap(NameOfThing name, EventTargetZones eventMethods) {
        JSFile inpkg = this.getPackage(name.packageName());
        inpkg.eventMap(name, eventMethods);
    }

    @Override
    public void applRouting(JSClassCreator clz, NameOfThing name, ApplicationRouting routes) {
        JSFile inpkg = this.getPackage(name.packageName());
        inpkg.applRouting(clz, name, routes);
    }

    public JSFile getPackage(NameOfThing pkg) {
        if (pkg == null || pkg.uniqueName() == null) {
            pkg = new PackageName("root.package");
        } else if (pkg.uniqueName().contains("__")) {
            throw new CantHappenException("there should not be a __ in the package name: " + pkg);
        }
        JSFile inpkg = this.files.get(pkg.uniqueName());
        if (inpkg == null) {
            String name = pkg.uniqueName() + ".js";
            inpkg = new JSFile(this.repository, pkg, name);
            this.files.put(pkg.uniqueName(), inpkg);
        }
        return inpkg;
    }

    @Override
    public void struct(StructDefn s) {
        this.structs.add(s);
    }

    @Override
    public void contract(ContractDecl cd) {
        this.contracts.add(cd);
    }

    @Override
    public void object(ObjectDefn cd) {
        this.objects.add(cd);
    }

    @Override
    public void handler(HandlerImplements hi) {
        this.handlers.add(hi);
    }

    @Override
    public void complete() {
        for (Map.Entry<String, JSFile> p : this.files.entrySet()) {
            String pkg = p.getKey();
            if (pkg.contains("._ut_") || pkg.contains("_st_")) continue;
            PackageName pp = new PackageName(pkg);
            JSMethod ifn = new JSMethod(this, null, pp, false, "_init");
            ifn.noJVM();
            ifn.argument("_cxt");
            for (ContractDecl contractDecl : this.contracts) {
                ifn.cxtMethod("registerContract", new JSString(contractDecl.name().uniqueName()), ifn.newOf(contractDecl.name()));
            }
            for (ObjectDefn objectDefn : this.objects) {
                ifn.cxtMethod("registerObject", new JSString(objectDefn.name().uniqueName()), ifn.literal(objectDefn.name().jsName()));
            }
            for (HandlerImplements handlerImplements : this.handlers) {
                ifn.cxtMethod("registerStruct", new JSString(handlerImplements.name().uniqueName()), ifn.literal(handlerImplements.name().jsName()));
            }
            for (StructDefn structDefn : this.structs) {
                ifn.cxtMethod("registerStruct", new JSString(structDefn.name().uniqueName()), ifn.literal(structDefn.name().jsName()));
            }
            ifn.ifTrue(new JSLiteral(pp.jsName() + "._builtin_init")).trueCase().callMethod("void", null, pp.jsName() + "._builtin_init", new JSExpr[0]);
            p.getValue().addFunction(ifn);
        }
    }

    public void dumpAll(boolean b) {
        for (ContentObject f : this.files()) {
            System.out.println("JSFile " + f.key());
            try {
                InputStream cos = f.asStream();
                try {
                    FileUtils.copyStreamWithoutClosingEither((InputStream)cos, (OutputStream)System.out);
                }
                finally {
                    if (cos == null) continue;
                    cos.close();
                }
            }
            catch (IOException ex) {
                System.err.println("could not dump " + f.key());
            }
        }
    }

    public void generateCOs() throws IOException {
        Collection<String> imports = this.fileImports();
        for (JSFile jsf : this.files.values()) {
            ContentObject co = jsf.generate(this.config, imports);
            this.gencos.put(jsf.key(), co);
        }
    }

    public void saveCOsTo(File flimdir) {
        FileUtils.assertDirectory((File)flimdir);
        for (JSFile jsf : this.files.values()) {
            jsf.saveTo(flimdir);
        }
    }

    public void upload(JSUploader uploader) throws IOException {
        for (JSFile jsf : this.files.values()) {
            ContentObject co = jsf.upload(uploader);
            if (co != null) {
                this.gencos.put(jsf.key(), co);
                continue;
            }
            this.localOnly.add(jsf.co());
        }
    }

    private Collection<String> fileImports() {
        Iterable wantedPkgs = this.packageStrings();
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (String s : this.files.keySet()) {
            if (s.contains("_ut") || s.contains("_st")) continue;
            ret.add(s);
        }
        for (String s : this.repository.flimPackages()) {
            if (s.contains("_ut") || s.contains("_st") || !wantedPkgs.contains(s)) continue;
            ret.add(s);
        }
        this.additionalModulePackages(ret);
        return ret;
    }

    public void generate(ByteCodeEnvironment bce) {
        for (JSFile jsf : this.files.values()) {
            jsf.generate(bce);
        }
    }

    public Collection<PackageName> packageNames() {
        Iterable strings = this.packageStrings();
        LinkedHashSet<PackageName> ret = new LinkedHashSet<PackageName>();
        for (String s : strings) {
            ret.add(new PackageName(s));
        }
        return ret;
    }

    public Collection<String> packageStrings() {
        final Collection<String> flims = this.repository.flimPackages();
        final LinkedHashSet<String> ret = new LinkedHashSet<String>();
        if (this.pkgdag.hasNode((Object)"root.package")) {
            ret.add("root.package");
        }
        for (String s : this.files.keySet()) {
            this.pkgdag.ensure((Object)s);
            this.pkgdag.postOrderFrom((NodeWalker)new NodeWalker<String>(){

                public void present(Node<String> node) {
                    String pkg = (String)node.getEntry();
                    if (JSEnvironment.this.files.containsKey(pkg) || flims.contains(pkg)) {
                        ret.add(pkg);
                    }
                }
            }, (Object)s);
        }
        this.additionalModulePackages(ret);
        return ret;
    }

    private void additionalModulePackages(LinkedHashSet<String> ret) {
        for (String m : this.config.modules) {
            File pf;
            File mdir = new File(this.config.moduleDir, m);
            if (!mdir.isDirectory() || !(pf = new File(mdir, "packages")).canRead()) continue;
            for (String s : FileUtils.readFileAsLines((File)pf)) {
                ret.add(s);
            }
        }
    }

    @Override
    public Iterable<ContentObject> jsIncludes(String mockOrLive) {
        ArrayList<ContentObject> ret = new ArrayList<ContentObject>();
        if (this.config.flascklibDir != null) {
            this.figureJSFilesOnDisk(ret, this.config, mockOrLive);
        } else if (this.config.flascklibCPV != null) {
            this.figureJSFilesFromContentStore(ret, this.config, mockOrLive);
        }
        return ret;
    }

    private void figureJSFilesOnDisk(List<ContentObject> ret, Configuration config, String mockOrLive) {
        ArrayList<String> inlib = new ArrayList<String>();
        File fljs = new File(config.flascklibDir, "js");
        this.addFrom(ret, inlib, new File(fljs, "core"));
        this.addFrom(ret, inlib, new File(fljs, mockOrLive));
        for (String mld : config.modules) {
            this.addModule(ret, config.moduleDir, inlib, mld, mockOrLive);
        }
        Iterable pkgs = this.packageStrings();
        for (String s : pkgs) {
            if (mockOrLive.equals("live") && (s.contains("_ut_") || s.contains("_st_"))) continue;
            ContentObject co = this.fileFor(s);
            if (co != null) {
                ret.add(co);
                inlib.add(co.key());
                continue;
            }
            boolean added = false;
            File inc = new File(config.writeFlim, s + ".js");
            if (inc.exists() && !inlib.contains(inc.getName())) {
                ret.add((ContentObject)new FileContentObject(inc));
                inlib.add(inc.getName());
                added = true;
            }
            for (File q : config.includeFrom) {
                for (File i : FileUtils.findFilesMatching((File)q, (String)(s + ".js"))) {
                    if (inlib.contains(i.getName())) continue;
                    ret.add((ContentObject)new FileContentObject(i));
                    inlib.add(i.getName());
                    added = true;
                }
            }
            if (added) continue;
            this.errors.message((InputPosition)null, "no files could be added for package " + s);
        }
    }

    private void addModule(List<ContentObject> ret, File moduleDir, List<String> inlib, String m, String mockOrLive) {
        File f = new File(moduleDir, m);
        if (!f.isDirectory()) {
            throw new InvalidUsageException("there is no module " + m + " defined in " + moduleDir);
        }
        File mjs = new File(f, "js");
        this.addFrom(ret, inlib, new File(mjs, "core"));
        this.addFrom(ret, inlib, new File(mjs, mockOrLive));
    }

    private void addFrom(List<ContentObject> ret, List<String> inlib, File from) {
        if (!from.isDirectory()) {
            return;
        }
        List library = FileUtils.findFilesMatching((File)from, (String)"*");
        for (File f : library) {
            ret.add((ContentObject)new FileContentObject(f));
            inlib.add(f.getName());
        }
    }

    private void figureJSFilesFromContentStore(List<ContentObject> ret, Configuration config, String mockOrLive) {
        for (ContentObject co : config.flascklibCPV.corejs()) {
            ret.add(co);
        }
        if (mockOrLive.equals("live")) {
            for (ContentObject co : config.flascklibCPV.livejs()) {
                ret.add(co);
            }
        }
        if (mockOrLive.equals("mock")) {
            for (ContentObject co : config.flascklibCPV.mockjs()) {
                ret.add(co);
            }
        }
        if (config.moduleCOs != null) {
            for (PackageSources d : config.moduleCOs) {
                for (ContentObject co : d.corejs()) {
                    ret.add(co);
                }
                if (mockOrLive.equals("live")) {
                    for (ContentObject co : d.livejs()) {
                        ret.add(co);
                    }
                }
                if (!mockOrLive.equals("mock")) continue;
                for (ContentObject co : d.mockjs()) {
                    ret.add(co);
                }
            }
        }
        if (config.dependencies != null) {
            for (PackageSources d : config.dependencies) {
                for (ContentObject co : d.corejs()) {
                    ret.add(co);
                }
                if (mockOrLive.equals("live")) {
                    for (ContentObject co : d.livejs()) {
                        ret.add(co);
                    }
                }
                if (!mockOrLive.equals("mock")) continue;
                for (ContentObject co : d.mockjs()) {
                    ret.add(co);
                }
            }
        }
        for (ContentObject co : this.gencos.values()) {
            ret.add(co);
        }
        for (ContentObject co : this.localOnly) {
            ret.add(co);
        }
    }

    public void asivm() {
        for (JSFile f : this.files.values()) {
            f.asivm();
        }
    }

    public String toString() {
        return "JSEnv[" + this.files + "]";
    }
}

