/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.packaging;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.compiler.jsgen.form.JSString;
import org.flasck.flas.compiler.templates.EventPlacement;
import org.flasck.flas.compiler.templates.EventTargetZones;
import org.flasck.jvm.J;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.GenericAnnotator;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.Var;
import org.zinutils.bytecode.mock.IndentWriter;

public class EventMap {
    private final NameOfThing cardName;
    private final EventTargetZones methods;

    public EventMap(NameOfThing cardName, EventTargetZones eventMethods) {
        this.cardName = cardName;
        this.methods = eventMethods;
    }

    public void write(IndentWriter iw) {
        IndentWriter lw;
        iw.println(this.cardName.jsName() + ".prototype._eventHandlers = function() {");
        IndentWriter jw = iw.indent();
        jw.print("return {");
        IndentWriter kw = jw.indent();
        boolean isFirst = true;
        for (String t : this.methods.templateNames()) {
            if (!isFirst) {
                kw.println(",");
            } else {
                kw.println("");
            }
            isFirst = false;
            kw.print(new JSString(t).asVar());
            kw.print(" : [");
            lw = kw.indent();
            boolean ft = true;
            for (EventPlacement.TemplateTarget tt : this.methods.targets(t)) {
                ft = this.writeHi(ft, lw, tt.type, tt.slot, tt.option, this.methods.getHandler(tt.handler), tt.evcond);
            }
            if (!ft) {
                kw.println("");
            }
            kw.println("]");
            jw.newline();
        }
        List<EventPlacement.HandlerInfo> unbound = this.methods.unboundHandlers();
        if (!unbound.isEmpty()) {
            if (!isFirst) {
                kw.println(",");
            } else {
                kw.println("");
            }
            kw.print("_: [");
            boolean ft = true;
            lw = kw.indent();
            for (EventPlacement.HandlerInfo hi : unbound) {
                ft = this.writeHi(ft, lw, null, null, 0, hi, null);
            }
            if (!ft) {
                kw.println("");
            }
            kw.println("]");
            jw.newline();
        }
        jw.println("};");
        iw.println("};");
    }

    private boolean writeHi(boolean ft, IndentWriter lw, String type, String slot, int option, EventPlacement.HandlerInfo hi, Integer evcond) {
        if (!ft) {
            lw.println(",");
        } else {
            lw.println("");
        }
        lw.print("{ ");
        if (type != null) {
            lw.print("type: ");
            lw.print(new JSString(type).asVar());
            lw.print(", slot: ");
            lw.print(new JSString(slot).asVar());
            lw.print(", ");
            lw.print("option: ");
            lw.print(Integer.toString(option));
            lw.print(", ");
        }
        lw.print("event: ");
        lw.print(hi.event);
        lw.print(", handler: ");
        lw.print(hi.name.jsPName());
        if (evcond != null) {
            lw.print(", cond: ");
            lw.print(evcond.toString());
        }
        lw.print(" }");
        return false;
    }

    public void generate(ByteCodeEnvironment bce) {
        if (bce == null) {
            return;
        }
        ByteCodeSink bcc = bce.getOrCreate(this.cardName.javaName());
        GenericAnnotator gen = GenericAnnotator.newMethod((ByteCodeSink)bcc, (boolean)false, (String)"_eventHandlers");
        gen.returns(Map.class.getName());
        MethodDefiner meth = gen.done();
        meth.lenientMode(false);
        Var v = meth.avar(Map.class.getName(), "ret");
        meth.assign(v, meth.makeNew(TreeMap.class.getName(), new IExpr[0])).flush();
        for (String t : this.methods.templateNames()) {
            Var hl = meth.avar(List.class.getName(), "hl");
            meth.assign(hl, meth.makeNew(ArrayList.class.getName(), new IExpr[0])).flush();
            for (EventPlacement.TemplateTarget tt : this.methods.targets(t)) {
                IExpr esl;
                IExpr ety;
                EventPlacement.HandlerInfo hi = this.methods.getHandler(tt.handler);
                IExpr classArgs = meth.arrayOf(Class.class.getName(), new IExpr[]{meth.classConst(J.FLEVALCONTEXT), meth.classConst("[L" + J.OBJECT + ";")});
                IExpr ehm = meth.callVirtual(Method.class.getName(), meth.classConst(this.cardName.javaName()), "getDeclaredMethod", new IExpr[]{meth.stringConst(hi.name.name), classArgs});
                if (tt.type != null) {
                    ety = meth.stringConst(tt.type);
                    esl = meth.stringConst(tt.slot);
                } else {
                    ety = meth.as(meth.aNull(), J.STRING);
                    esl = meth.as(meth.aNull(), J.STRING);
                }
                IExpr icond = tt.evcond != null ? meth.box(meth.intConst(tt.evcond.intValue())) : meth.as(meth.aNull(), J.INTEGER);
                IExpr ghi = meth.makeNew(J.HANDLERINFO, new IExpr[]{ety, esl, meth.box(meth.intConst(tt.option)), meth.stringConst(hi.event), ehm, icond});
                meth.voidExpr(meth.callInterface("boolean", (IExpr)hl, "add", new IExpr[]{meth.as(ghi, J.OBJECT)})).flush();
            }
            meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)v, "put", new IExpr[]{meth.as(meth.stringConst(t), J.OBJECT), meth.as((IExpr)hl, J.OBJECT)})).flush();
        }
        if (!this.methods.unboundHandlers().isEmpty()) {
            Var hl = meth.avar(List.class.getName(), "hl");
            meth.assign(hl, meth.makeNew(ArrayList.class.getName(), new IExpr[0])).flush();
            for (EventPlacement.HandlerInfo hi : this.methods.unboundHandlers()) {
                IExpr classArgs = meth.arrayOf(Class.class.getName(), new IExpr[]{meth.classConst(J.FLEVALCONTEXT), meth.classConst("[L" + J.OBJECT + ";")});
                IExpr ehm = meth.callVirtual(Method.class.getName(), meth.classConst(this.cardName.javaName()), "getDeclaredMethod", new IExpr[]{meth.stringConst(hi.name.name), classArgs});
                IExpr ghi = meth.makeNew(J.HANDLERINFO, new IExpr[]{meth.as(meth.aNull(), J.STRING), meth.as(meth.aNull(), J.STRING), meth.as(meth.aNull(), J.INTEGER), meth.stringConst(hi.event), ehm, meth.as(meth.aNull(), J.INTEGER)});
                meth.voidExpr(meth.callInterface("boolean", (IExpr)hl, "add", new IExpr[]{meth.as(ghi, J.OBJECT)})).flush();
            }
            meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)v, "put", new IExpr[]{meth.as(meth.stringConst("_"), J.OBJECT), meth.as((IExpr)hl, J.OBJECT)})).flush();
        }
        meth.returnObject((IExpr)v).flush();
    }
}

