/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.packaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.assembly.ApplicationRouting;
import org.flasck.flas.parsedForm.assembly.RoutingAction;
import org.flasck.flas.parsedForm.assembly.RoutingActions;
import org.flasck.flas.parsedForm.assembly.SubRouting;
import org.flasck.flas.resolver.ApplicationRoutingResolver;
import org.flasck.jvm.J;
import org.flasck.jvm.container.ArgType;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.GenericAnnotator;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.Var;
import org.zinutils.bytecode.mock.IndentWriter;

public class ApplRoutingTable {
    private final NameOfThing applName;
    private final ApplicationRouting routes;

    public ApplRoutingTable(NameOfThing applName, ApplicationRouting routes) {
        this.applName = applName;
        this.routes = routes;
    }

    public void write(IndentWriter iw) {
        iw.println(this.applName.jsName() + "._Application.prototype._routing = function() {");
        IndentWriter jw = iw.indent();
        jw.println("return {");
        IndentWriter kw = jw.indent();
        this.common(kw, this.routes);
        jw.println("};");
        iw.println("};");
    }

    private void common(IndentWriter kw, SubRouting r) {
        if (r.hasTitle()) {
            kw.println("title: '" + r.getTitle() + "',");
        }
        kw.println("secure: " + r.requiresSecurity + ",");
        kw.println("cards: [");
        boolean s2 = false;
        IndentWriter lw = kw.indent();
        for (ApplicationRouting.CardBinding ca : r.assignments) {
            if (s2) {
                lw.println(",");
            }
            lw.print("{ ");
            lw.print("name: '" + ca.var.var + "', ");
            lw.print("card: " + ca.cardType.namedDefn().name().jsName());
            lw.print(" }");
            s2 = true;
        }
        lw.println("");
        kw.println("],");
        kw.println("enter: [");
        this.handleActions(kw.indent(), r.enter);
        kw.println("],");
        kw.println("at: [");
        this.handleActions(kw.indent(), r.at);
        kw.println("],");
        kw.println("exit: [");
        this.handleActions(kw.indent(), r.exit);
        kw.println("],");
        kw.println("routes: [");
        this.handleRoutes(kw.indent(), r.routes);
        kw.println("]");
    }

    private void handleActions(IndentWriter lw, RoutingActions actions) {
        if (actions == null) {
            return;
        }
        boolean sep = false;
        for (RoutingAction ra : actions.actions) {
            if (sep) {
                lw.println(",");
            }
            sep = true;
            lw.print("{ ");
            lw.print("card: '" + ra.card.var + "', ");
            lw.print("contract: '" + ra.contract.namedDefn().signature() + "', ");
            lw.print("action: '" + ra.action + "', args: [");
            boolean first = true;
            for (Expr e : ra.exprs) {
                if (!first) {
                    lw.print(", ");
                }
                first = false;
                if (e instanceof StringLiteral) {
                    StringLiteral sl = (StringLiteral)e;
                    lw.print("{ str: '" + sl.text + "' }");
                    continue;
                }
                if (e instanceof UnresolvedVar) {
                    UnresolvedVar uv = (UnresolvedVar)e;
                    if (uv.defn() instanceof ApplicationRoutingResolver.ParameterRepositoryEntry) {
                        lw.print("{ param: '" + uv.var + "' }");
                        continue;
                    }
                    lw.print("{ ref: '" + uv.var + "' }");
                    continue;
                }
                lw.print("{ expr: 'routing_expr_0' }");
            }
            lw.print("] }");
        }
        lw.println("");
    }

    private void handleRoutes(IndentWriter lw, List<SubRouting> routes) {
        if (routes.isEmpty()) {
            return;
        }
        boolean sep = false;
        for (SubRouting r : routes) {
            if (sep) {
                lw.println(",");
            }
            sep = true;
            lw.println("{");
            IndentWriter mw = lw.indent();
            if (r.path.startsWith("{")) {
                mw.println("param: '" + r.path.substring(1, r.path.length() - 1) + "', ");
            } else {
                mw.println("path: '" + r.path + "', ");
            }
            this.common(mw, r);
            lw.print("}");
        }
        lw.println("");
    }

    public void generate(ByteCodeEnvironment bce) {
        if (bce == null) {
            return;
        }
        ByteCodeSink bcc = bce.getOrCreate(this.applName.javaName() + "._Application");
        GenericAnnotator gen = GenericAnnotator.newMethod((ByteCodeSink)bcc, (boolean)false, (String)"_routing");
        gen.returns(Map.class.getName());
        MethodDefiner meth = gen.done();
        meth.lenientMode(false);
        Var v = meth.avar(Map.class.getName(), "ret");
        meth.assign(v, meth.makeNew(TreeMap.class.getName(), new IExpr[0])).flush();
        AtomicInteger rn = new AtomicInteger(0);
        this.jvmcommon((NewMethodDefiner)meth, v, this.routes, rn);
        meth.returnObject((IExpr)v).flush();
    }

    private void jvmcommon(NewMethodDefiner meth, Var v, SubRouting r, AtomicInteger rn) {
        if (r.hasTitle()) {
            meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)v, "put", new IExpr[]{meth.as(meth.stringConst("title"), J.OBJECT), meth.as(meth.stringConst(r.getTitle()), J.OBJECT)})).flush();
        }
        meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)v, "put", new IExpr[]{meth.as(meth.stringConst("secure"), J.OBJECT), meth.as(meth.box((IExpr)meth.boolConst(r.requiresSecurity)), J.OBJECT)})).flush();
        Var cards = meth.avar(List.class.getName(), "cards_" + rn.incrementAndGet());
        meth.assign(cards, meth.makeNew(ArrayList.class.getName(), new IExpr[0])).flush();
        meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)v, "put", new IExpr[]{meth.as(meth.stringConst("cards"), J.OBJECT), meth.as((IExpr)cards, J.OBJECT)})).flush();
        for (ApplicationRouting.CardBinding ca : r.assignments) {
            IExpr mn = meth.makeNew(J.FLCARDASSIGNMENT, new IExpr[]{meth.stringConst(ca.var.var), meth.stringConst(ca.cardType.namedDefn().name().javaName())});
            meth.voidExpr(meth.callInterface("boolean", (IExpr)cards, "add", new IExpr[]{meth.as(mn, J.OBJECT)})).flush();
        }
        this.genActions(meth, v, "enter", r.enter, rn);
        this.genActions(meth, v, "at", r.at, rn);
        this.genActions(meth, v, "exit", r.exit, rn);
        this.genRoutes(meth, v, r.routes, rn);
    }

    private void genActions(NewMethodDefiner meth, Var v, String label, RoutingActions actions, AtomicInteger rn) {
        if (actions == null) {
            return;
        }
        Var list = meth.avar(List.class.getName(), "actions_" + rn.incrementAndGet());
        meth.assign(list, meth.makeNew(ArrayList.class.getName(), new IExpr[0])).flush();
        for (RoutingAction ra : actions.actions) {
            ArrayList<IExpr> exprs = new ArrayList<IExpr>();
            int pos = 0;
            for (Expr e : ra.exprs) {
                ArgType at;
                Object val;
                if (e instanceof StringLiteral) {
                    val = ((StringLiteral)e).text;
                    at = ArgType.STRING;
                } else if (e instanceof UnresolvedVar) {
                    UnresolvedVar uv = (UnresolvedVar)e;
                    val = uv.var;
                    at = uv.defn() instanceof ApplicationRoutingResolver.ParameterRepositoryEntry ? ArgType.PARAM : ArgType.CARDREF;
                } else {
                    at = ArgType.EXPR;
                    val = "routing_expr_" + ra.exprFor(pos);
                }
                org.zinutils.bytecode.Expr ate = meth.staticField(ArgType.class.getName(), ArgType.class.getName(), at.name());
                exprs.add(meth.makeNew(J.FLROUTINGARG, new IExpr[]{ate, meth.stringConst((String)val)}));
                ++pos;
            }
            IExpr mn = meth.makeNew(J.FLROUTINGACTION, new IExpr[]{meth.stringConst(ra.card.var), meth.stringConst(ra.contract.namedDefn().signature()), meth.stringConst(ra.action), meth.arrayOf(J.FLROUTINGARG, exprs)});
            meth.voidExpr(meth.callInterface("boolean", (IExpr)list, "add", new IExpr[]{meth.as(mn, J.OBJECT)})).flush();
        }
        meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)v, "put", new IExpr[]{meth.as(meth.stringConst(label), J.OBJECT), meth.as((IExpr)list, J.OBJECT)})).flush();
    }

    private void genRoutes(NewMethodDefiner meth, Var v, List<SubRouting> routes, AtomicInteger rn) {
        Var list = meth.avar(List.class.getName(), "routes_" + rn.incrementAndGet());
        meth.assign(list, meth.makeNew(ArrayList.class.getName(), new IExpr[0])).flush();
        for (SubRouting r : routes) {
            Var inner = meth.avar(Map.class.getName(), "inner_" + rn.incrementAndGet());
            meth.assign(inner, meth.makeNew(TreeMap.class.getName(), new IExpr[0])).flush();
            meth.voidExpr(meth.callInterface("boolean", (IExpr)list, "add", new IExpr[]{meth.as((IExpr)inner, J.OBJECT)})).flush();
            if (r.path.startsWith("{")) {
                meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)inner, "put", new IExpr[]{meth.as(meth.stringConst("param"), J.OBJECT), meth.as(meth.stringConst(r.path.substring(1, r.path.length() - 1)), J.OBJECT)})).flush();
            } else {
                meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)inner, "put", new IExpr[]{meth.as(meth.stringConst("path"), J.OBJECT), meth.as(meth.stringConst(r.path), J.OBJECT)})).flush();
            }
            this.jvmcommon(meth, inner, r, rn);
        }
        meth.voidExpr(meth.callInterface(J.OBJECT, (IExpr)v, "put", new IExpr[]{meth.as(meth.stringConst("routes"), J.OBJECT), meth.as((IExpr)list, J.OBJECT)})).flush();
    }
}

