/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.compiler.jsgen.JSGenerator;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSXCurry
implements JSExpr {
    private final boolean wantObject = false;
    private final List<JSGenerator.XCArg> args;
    private final int required;

    public JSXCurry(int required, List<JSGenerator.XCArg> posargs) {
        this.required = required;
        this.args = posargs;
    }

    @Override
    public void write(IndentWriter w) {
        w.print("_cxt.xcurry(" + this.required);
        for (JSGenerator.XCArg e : this.args) {
            w.print(", ");
            w.print(Integer.toString(e.arg));
            w.print(", ");
            w.print(e.expr.asVar());
        }
        w.print(")");
    }

    @Override
    public String asVar() {
        throw new RuntimeException("This should be wrapped in a JSLocal or JSThis");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        IExpr fn = null;
        ArrayList<IExpr> stack = new ArrayList<IExpr>();
        for (JSGenerator.XCArg xc : this.args) {
            JSExpr e = xc.expr;
            if (fn == null) {
                fn = jvm.arg(e);
                continue;
            }
            stack.add(md.box(md.intConst(xc.arg - 1)));
            stack.add(jvm.arg(e));
        }
        IExpr xcs = md.arrayOf(J.OBJECT, stack);
        IExpr call = md.callInterface(J.FLCURRY, jvm.cxt(), "xcurry", new IExpr[]{md.intConst(this.required), md.as(fn, J.APPLICABLE), xcs});
        jvm.local(this, call);
    }
}

