/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.compiler.jsgen.JSStyleIf;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSThis;
import org.flasck.flas.compiler.jsgen.form.JSVar;
import org.flasck.flas.parsedForm.TemplateField;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.NotImplementedException;

public class JSUpdateStyle
implements JSExpr {
    private final String templateName;
    private final TemplateField field;
    private final int option;
    private final JSExpr source;
    private final JSExpr constant;
    private final List<JSStyleIf> vars;

    public JSUpdateStyle(String templateName, TemplateField field, int option, JSExpr source, JSExpr c, List<JSStyleIf> styles) {
        this.templateName = templateName;
        this.field = field;
        this.option = option;
        this.source = source;
        this.constant = c;
        this.vars = new ArrayList<JSStyleIf>(styles);
    }

    @Override
    public String asVar() {
        throw new NotImplementedException("not for use");
    }

    @Override
    public void write(IndentWriter w) {
        w.print("this._updateStyle(_cxt, _renderTree, '");
        w.print(this.templateName);
        w.print("', ");
        if (this.field == null) {
            w.print("null, null, null, ");
        } else {
            w.print("'");
            w.print(this.field.type().toString().toLowerCase());
            w.print("', '");
            w.print(this.field.text);
            w.print("', ");
            w.print(Integer.toString(this.option));
            w.print(", ");
        }
        w.print(this.source.asVar());
        w.print(", ");
        w.print(this.constant.asVar());
        for (JSStyleIf si : this.vars) {
            w.print(", ");
            w.print(si.cond.asVar());
            w.print(", ");
            w.print(si.style.asVar());
        }
        w.println(");");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        IExpr tx;
        IExpr ty;
        NewMethodDefiner md = jvm.method();
        if (this.field == null) {
            ty = md.as(md.aNull(), J.STRING);
            tx = md.as(md.aNull(), J.STRING);
        } else {
            ty = md.stringConst(this.field.type().toString().toLowerCase());
            tx = md.stringConst(this.field.text);
        }
        IExpr ce = this.constant == null ? md.aNull() : jvm.arg(this.constant);
        ArrayList<IExpr> arr = new ArrayList<IExpr>();
        for (JSStyleIf si : this.vars) {
            arr.add(jvm.arg(si.cond));
            arr.add(jvm.arg(si.style));
        }
        IExpr me = md.callVirtual("void", jvm.argAsIs(new JSThis()), "_updateStyles", new IExpr[]{jvm.cxt(), jvm.argAsIs(new JSVar("_renderTree")), md.stringConst(this.templateName), ty, tx, md.intConst(this.option), jvm.arg(this.source), ce, md.arrayOf(J.OBJECT, arr)});
        jvm.local(this, me);
    }
}

