/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSThis;
import org.flasck.flas.compiler.jsgen.form.JSVar;
import org.flasck.flas.parsedForm.TemplateField;
import org.flasck.jvm.J;
import org.ziniki.splitter.FieldType;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class JSUpdateContent
implements JSExpr {
    private final String templateName;
    private final TemplateField field;
    private final int option;
    private final JSExpr source;
    private final String fromField;
    private final JSExpr expr;

    public JSUpdateContent(String templateName, TemplateField field, int option, JSExpr source, String fromField, JSExpr expr) {
        this.templateName = templateName;
        this.field = field;
        this.option = option;
        this.source = source;
        this.fromField = fromField;
        this.expr = expr;
    }

    @Override
    public String asVar() {
        throw new NotImplementedException("not for use");
    }

    @Override
    public void write(IndentWriter w) {
        if (this.field.type() == FieldType.CONTENT) {
            w.print("this._updateContent(_cxt, _renderTree, '");
        } else if (this.field.type() == FieldType.IMAGE) {
            w.print("this._updateImage(_cxt, _renderTree, '");
        } else if (this.field.type() == FieldType.LINK) {
            w.print("this._updateLink(_cxt, _renderTree, '");
        } else {
            throw new HaventConsideredThisException(this.field.type().name());
        }
        w.print(this.templateName);
        w.print("', '");
        w.print(this.field.text);
        w.print("', ");
        w.print(Integer.toString(this.option));
        w.print(", ");
        w.print(this.source.asVar());
        w.print(", ");
        w.print(this.expr.asVar());
        w.print(", ");
        if (this.fromField == null) {
            w.print("null");
        } else {
            w.print("\"" + this.fromField + "\"");
        }
        w.println(");");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        String fn;
        NewMethodDefiner md = jvm.method();
        if (this.field.type() == FieldType.CONTENT) {
            fn = "_updateContent";
        } else if (this.field.type() == FieldType.IMAGE) {
            fn = "_updateImage";
        } else if (this.field.type() == FieldType.LINK) {
            fn = "_updateLink";
        } else {
            throw new HaventConsideredThisException(this.field.type().name());
        }
        IExpr me = md.callVirtual("void", jvm.argAsIs(new JSThis()), fn, new IExpr[]{jvm.cxt(), jvm.argAsIs(new JSVar("_renderTree")), md.stringConst(this.templateName), md.stringConst(this.field.text), md.intConst(this.option), jvm.arg(this.source), jvm.arg(this.expr), this.fromField == null ? md.as(md.aNull(), J.STRING) : md.stringConst(this.fromField)});
        jvm.local(this, me);
    }
}

