/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSStoreField
implements JSExpr {
    private final boolean jsOnly;
    private final JSExpr inObj;
    private final String field;
    private final JSExpr value;

    public JSStoreField(boolean jsOnly, JSExpr inObj, String field, JSExpr value) {
        this.jsOnly = jsOnly;
        this.inObj = inObj;
        this.field = field;
        this.value = value;
    }

    @Override
    public void write(IndentWriter w) {
        if (this.inObj == null) {
            w.print("this");
        } else {
            w.print(this.inObj.asVar());
        }
        w.print(".state.set('");
        w.print(this.field);
        w.print("', ");
        w.print(this.value.asVar());
        w.println(");");
    }

    @Override
    public String asVar() {
        throw new RuntimeException("This should be wrapped in a JSLocal or JSThis");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        if (!this.jsOnly) {
            IExpr arg = jvm.arg(this.value);
            Object item = this.inObj == null ? md.myThis() : jvm.argAsIs(this.inObj);
            IExpr svar = md.getField((IExpr)item, "state");
            IExpr doset = md.callInterface("void", svar, "set", new IExpr[]{md.stringConst(this.field), arg});
            jvm.local(this, doset);
        } else {
            jvm.local(this, null);
        }
    }
}

