/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.IVFWriter;
import org.flasck.flas.compiler.jsgen.form.IVForm;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSThis;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSSetField
implements IVForm {
    private final JSExpr on;
    private final String field;
    private final JSExpr value;
    private boolean jsOnly;

    public JSSetField(boolean jsOnly, String field, JSExpr value) {
        this(new JSThis(), field, value);
        this.jsOnly = jsOnly;
    }

    public JSSetField(JSExpr on, String field, JSExpr value) {
        this.on = on;
        this.field = field;
        this.value = value;
    }

    @Override
    public String asVar() {
        return this.on.asVar() + "." + this.field;
    }

    @Override
    public void write(IndentWriter w) {
        w.print(this.on.asVar());
        w.print(".");
        w.print(this.field);
        w.print(" = ");
        w.print(this.value.asVar());
        w.println(";");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        if (this.jsOnly) {
            jvm.local(this, null);
            return;
        }
        if ("_contracts".equals(this.field)) {
            jvm.local(this, null);
            return;
        }
        if ("_template".equals(this.field)) {
            jvm.local(this, null);
            return;
        }
        NewMethodDefiner ctor = jvm.method();
        IExpr ret = ctor.assign(ctor.getField(this.field), jvm.argAsIs(this.value));
        jvm.local(this, ret);
    }

    @Override
    public void asivm(IVFWriter iw) {
        iw.print(this.on.asVar() + "[" + this.field + "] <- ");
        iw.write(this.value);
        iw.println("");
    }

    public String toString() {
        return "JSSetField[" + this.field + " <- " + this.value + "]";
    }
}

