/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSPushFunction
implements JSExpr {
    private final FunctionName name;
    private final String fn;
    private final int argCount;

    public JSPushFunction(FunctionName name, String fn, int argcount) {
        this.name = name;
        this.fn = fn;
        this.argCount = argcount;
    }

    @Override
    public void write(IndentWriter w) {
        w.print(this.fn);
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        NameOfThing clzName = this.name.containingCard();
        if (clzName == null) {
            String push = jvm.figureName(this.name);
            jvm.local(this, md.makeNew(J.CALLEVAL, new IExpr[]{md.classConst(push)}));
        } else {
            jvm.local(this, md.makeNew(J.CALLMETHOD, new IExpr[]{md.classConst(this.name.javaClassName()), md.stringConst(this.name.javaMethodName()), md.intConst(this.argCount)}));
        }
    }

    @Override
    public String asVar() {
        throw new RuntimeException("This should be wrapped in a JSLocal or JSThis");
    }

    public String toString() {
        return "push(" + this.fn + ")";
    }
}

