/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.NotImplementedException;

public class JSNew
implements JSExpr {
    private final NameOfThing clz;
    private final List<JSExpr> args;

    public JSNew(NameOfThing clz) {
        this(clz, new ArrayList<JSExpr>());
    }

    public JSNew(NameOfThing clz, List<JSExpr> args) {
        this.clz = clz;
        this.args = args;
    }

    @Override
    public String asVar() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(this.clz.jsName());
        sb.append("(_cxt");
        for (JSExpr e : this.args) {
            sb.append(", ");
            sb.append(e.asVar());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void write(IndentWriter w) {
        w.print(this.asVar());
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        String clzName;
        if (this.clz instanceof PackageName) {
            switch (this.clz.baseName()) {
                case "ResponseWithMessages": {
                    clzName = J.RESPONSE_WITH_MESSAGES;
                    break;
                }
                default: {
                    throw new NotImplementedException("cannot handle builtin name " + this.clz);
                }
            }
        } else {
            clzName = this.clz.javaName();
        }
        ArrayList<IExpr> stack = new ArrayList<IExpr>();
        stack.add(jvm.cxt());
        for (JSExpr a : this.args) {
            stack.add(jvm.arg(a));
        }
        IExpr ret = jvm.method().makeNew(clzName, stack.toArray(new IExpr[stack.size()]));
        jvm.local(this, ret);
    }
}

