/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.IVFWriter;
import org.flasck.flas.compiler.jsgen.form.IVForm;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSModuleStmt
implements IVForm {
    private final JSExpr obj;
    private final String javaIF;
    private final String jsName;

    public JSModuleStmt(JSExpr obj, String jsName, String javaIF) {
        this.obj = obj;
        this.javaIF = javaIF;
        this.jsName = jsName;
    }

    @Override
    public void write(IndentWriter w) {
        if (this.obj != null) {
            w.print(this.obj.asVar());
            w.print(".");
        }
        w.print("module('");
        w.print(this.jsName);
        w.print("')");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        IExpr mod = md.castTo(md.callInterface(J.OBJECT, jvm.argAsIs(this.obj), "module", new IExpr[]{md.stringConst(this.jsName)}), this.javaIF);
        jvm.local(this, mod);
    }

    @Override
    public void asivm(IVFWriter iw) {
        iw.println("module " + this.jsName);
    }

    @Override
    public String asVar() {
        return null;
    }
}

