/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSString;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSMakeSend
implements JSExpr {
    private final String sendMeth;
    private final JSExpr obj;
    private final int nargs;
    private final JSExpr handler;
    private final JSExpr handlerName;
    private String var;

    public JSMakeSend(String sendMeth, JSExpr obj, int nargs, JSExpr handler, JSExpr handlerName) {
        this.sendMeth = sendMeth;
        this.obj = obj;
        this.nargs = nargs;
        this.handler = handler;
        this.handlerName = handlerName;
    }

    @Override
    public void write(IndentWriter w) {
        w.print("_cxt.mksend(");
        w.print(new JSString(this.sendMeth).asVar());
        w.print(",");
        w.print(this.obj.asVar());
        w.print(",");
        w.print(Integer.toString(this.nargs));
        w.print(",");
        if (this.handler != null) {
            w.print(this.handler.asVar());
        } else {
            w.print("null");
        }
        w.print(",");
        if (this.handlerName != null) {
            w.print(this.handlerName.asVar());
        } else {
            w.print("null");
        }
        w.print(")");
    }

    @Override
    public String asVar() {
        return this.var;
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        IExpr h = this.handler != null ? jvm.arg(this.handler) : md.aNull();
        IExpr sn = this.handlerName != null ? jvm.arg(this.handlerName) : md.aNull();
        IExpr mksend = md.callInterface(J.OBJECT, jvm.cxt(), "mksend", new IExpr[]{md.stringConst(this.sendMeth), jvm.arg(this.obj), md.intConst(this.nargs), h, sn});
        jvm.local(this, mksend);
    }

    public String toString() {
        return "MakeSend[" + this.sendMeth + "]";
    }
}

