/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JSMethod;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.IVFWriter;
import org.flasck.flas.compiler.jsgen.form.IVForm;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSVar;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.Var;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.NotImplementedException;

public class JSLocal
implements IVForm {
    private final JSMethod meth;
    public final JSExpr value;
    private String var;

    public JSLocal(JSMethod meth, JSExpr value) {
        this.meth = meth;
        this.value = value;
    }

    @Override
    public String asVar() {
        if (this.var == null) {
            this.var = this.meth.obtainNextVar();
        }
        return this.var;
    }

    @Override
    public void write(IndentWriter w) {
        if (this.var == null) {
            this.var = this.meth.obtainNextVar();
        }
        w.print("const ");
        w.print(this.var);
        w.print(" = ");
        this.value.write(w);
        w.println(";");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        IExpr arg;
        if (this.var == null) {
            this.var = this.meth.obtainNextVar();
        }
        if ((arg = jvm.argAsIs(this.value)) == null) {
            throw new NotImplementedException("there is no value for " + this.value.getClass() + " " + this.value);
        }
        NewMethodDefiner md = jvm.method();
        Var v = arg.getType().equals("boolean") ? md.ivar("boolean", this.var) : md.avar(arg.getType(), this.var);
        jvm.local(this, md.assign(v, arg));
        jvm.bindVar(this, v);
        jvm.bindVar(new JSVar(this.var), v);
    }

    @Override
    public void asivm(IVFWriter iw) {
        iw.print(this.asVar() + " <- ");
        iw.write(this.value);
        iw.println("");
    }

    public String toString() {
        return this.asVar() + " <- " + this.value;
    }
}

