/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.NotImplementedException;

public class JSLiteral
implements JSExpr {
    private final String text;

    public JSLiteral(String text) {
        this.text = text;
    }

    @Override
    public void write(IndentWriter w) {
        w.print(this.text);
    }

    @Override
    public String asVar() {
        return this.text;
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        IExpr ret = null;
        if ("null".equals(this.text)) {
            ret = md.aNull();
        } else if ("true".equals(this.text)) {
            ret = md.boolConst(true);
        } else if ("false".equals(this.text)) {
            ret = md.boolConst(false);
        } else if ("_card".equals(this.text) || "this._card".equals(this.text)) {
            ret = md.getField("_card");
        } else if ("this._card._renderTree".equals(this.text)) {
            ret = md.getField(md.getField("_card"), "_renderTree");
        } else {
            try {
                double x = Double.parseDouble(this.text);
                ret = md.makeNew(Double.class.getName(), new IExpr[]{md.doubleConst(x)});
            }
            catch (NumberFormatException ex) {
                throw new NotImplementedException("non-integer cases: " + this.text);
            }
        }
        jvm.local(this, ret);
    }

    public String toString() {
        return "Literal[" + this.text + "]";
    }
}

