/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JSBlockCreator;
import org.flasck.flas.compiler.jsgen.creators.JSIfCreator;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSIfExpr
implements JSIfCreator {
    private final JSExpr test;
    private final JSBlockCreator trueCase;
    private final JSBlockCreator falseCase;

    public JSIfExpr(JSExpr test, JSBlockCreator trueCase, JSBlockCreator falseCase) {
        this.test = test;
        this.trueCase = trueCase;
        this.falseCase = falseCase;
    }

    @Override
    public JSBlockCreator trueCase() {
        return this.trueCase;
    }

    @Override
    public JSBlockCreator falseCase() {
        return this.falseCase;
    }

    @Override
    public String asVar() {
        return null;
    }

    @Override
    public void write(IndentWriter w) {
        w.print("if (");
        this.test.write(w);
        w.print(") ");
        this.trueCase.write(w);
        JSExpr ec = this.falseCase.singleton();
        if (ec != null) {
            w.print(" else ");
            if (ec instanceof JSIfExpr) {
                ec.write(w);
            } else {
                w.println("");
                ec.write(w.indent());
            }
        } else if (this.falseCase.isEmpty()) {
            w.println("");
        } else {
            w.print(" else ");
            this.falseCase.write(w);
            w.println("");
        }
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        this.test.generate(jvm);
        JVMCreationContext jt = jvm.split();
        this.trueCase.generate(jt);
        JVMCreationContext jf = jvm.split();
        this.falseCase.generate(jf);
        IExpr ret = md.ifBoolean(jvm.argAs(this.test, JavaType.boolean_), jt.blk(this.trueCase), jf.blk(this.falseCase));
        jvm.local(this, ret);
    }
}

