/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.NotImplementedException;

public class JSExpectation
implements JSExpr {
    private final JSExpr mock;
    private final String method;
    private final List<JSExpr> args;
    private final JSExpr handler;

    public JSExpectation(JSExpr mock, String method, List<JSExpr> args, JSExpr handler) {
        this.mock = mock;
        this.method = method;
        this.args = args;
        this.handler = handler;
    }

    @Override
    public String asVar() {
        throw new NotImplementedException();
    }

    @Override
    public void write(IndentWriter w) {
        w.print(this.mock.asVar());
        w.print(".expect(");
        w.print("'" + this.method + "'");
        w.print(", [");
        String sep = "";
        for (JSExpr a : this.args) {
            w.print(sep);
            sep = ", ";
            w.print(a.asVar());
        }
        w.print("], ");
        w.print(this.handler.asVar());
        w.println(");");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        ArrayList<IExpr> stack = new ArrayList<IExpr>();
        for (JSExpr je : this.args) {
            stack.add(jvm.arg(je));
        }
        if (!jvm.hasLocal(this.handler)) {
            if (this.handler != null) {
                this.handler.generate(jvm);
            } else {
                jvm.local(this.handler, md.aNull());
            }
        }
        IExpr mk = md.castTo(jvm.argAsIs(this.mock), J.EXPECTING);
        IExpr x = md.voidExpr(md.callInterface(J.MOCKEXPECTATION, mk, "expect", new IExpr[]{md.stringConst(this.method), md.arrayOf(J.OBJECT, stack), jvm.arg(this.handler)}));
        jvm.local(this, x);
    }
}

