/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import java.util.ArrayList;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSCurry
implements JSExpr {
    private final boolean wantObject;
    private final int required;
    public final JSExpr[] args;

    public JSCurry(boolean wantObject, int required, JSExpr ... args) {
        this.wantObject = wantObject;
        this.required = required;
        this.args = args;
    }

    @Override
    public void write(IndentWriter w) {
        if (this.wantObject) {
            w.print("_cxt.ocurry(");
            w.print(Integer.toString(this.required - 1));
        } else {
            w.print("_cxt.curry(");
            w.print(Integer.toString(this.required));
        }
        for (JSExpr e : this.args) {
            w.print(", ");
            w.print(e.asVar());
        }
        w.print(")");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        IExpr fn = null;
        ArrayList<IExpr> stack = new ArrayList<IExpr>();
        for (JSExpr e : this.args) {
            if (fn == null) {
                fn = jvm.arg(e);
                continue;
            }
            stack.add(jvm.arg(e));
        }
        IExpr as = md.arrayOf(J.OBJECT, stack);
        IExpr call = this.wantObject ? md.callInterface(J.FLCURRY, jvm.cxt(), "ocurry", new IExpr[]{md.intConst(this.required - 1), md.as(fn, J.APPLICABLE), as}) : md.callInterface(J.FLCURRY, jvm.cxt(), "curry", new IExpr[]{md.intConst(this.required), md.as(fn, J.APPLICABLE), as});
        jvm.local(this, call);
    }

    @Override
    public String asVar() {
        throw new RuntimeException("This should be wrapped in a JSLocal or JSThis");
    }
}

