/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import java.util.Arrays;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSEffector;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSClosure
implements JSExpr,
JSEffector {
    private final boolean wantObject;
    private final JSExpr[] args;

    public JSClosure(boolean wantObject, JSExpr ... args) {
        this.wantObject = wantObject;
        this.args = args;
    }

    @Override
    public void write(IndentWriter w) {
        if (this.wantObject) {
            w.print("_cxt.oclosure(");
        } else {
            w.print("_cxt.closure(");
        }
        boolean isFirst = true;
        for (JSExpr e : this.args) {
            if (isFirst) {
                isFirst = false;
            } else {
                w.print(", ");
            }
            w.print(e.asVar());
        }
        w.print(")");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner md = jvm.method();
        IExpr fn = null;
        IExpr[] grp = new IExpr[this.args.length - 1];
        for (int i = 0; i < this.args.length; ++i) {
            JSExpr ai = this.args[i];
            if (i == 0) {
                fn = jvm.arg(ai);
                continue;
            }
            grp[i - 1] = jvm.arg(ai);
        }
        IExpr as = md.arrayOf(J.OBJECT, grp);
        IExpr call = this.wantObject ? md.callInterface(J.FLCLOSURE, jvm.cxt(), "oclosure", new IExpr[]{md.as(fn, J.APPLICABLE), as}) : md.callInterface(J.FLCLOSURE, jvm.cxt(), "closure", new IExpr[]{md.as(fn, J.APPLICABLE), as});
        jvm.local(this, call);
    }

    @Override
    public String asVar() {
        throw new RuntimeException("This should be wrapped in a JSLocal or JSThis");
    }

    @Override
    public boolean hasSameEffectAs(JSExpr other) {
        if (!(other instanceof JSClosure)) {
            return false;
        }
        JSClosure o = (JSClosure)other;
        if (this.wantObject != o.wantObject) {
            return false;
        }
        if (this.args.length != o.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == o.args[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return (this.wantObject ? "obj::" : "") + Arrays.asList(this.args);
    }
}

