/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSCallMethod
implements JSExpr {
    private String returnType;
    private JSExpr obj;
    private String method;
    private final JSExpr[] args;

    public JSCallMethod(String returnType, JSExpr obj, String method, JSExpr ... args) {
        this.returnType = returnType;
        this.obj = obj;
        this.method = method;
        this.args = args;
    }

    @Override
    public void write(IndentWriter w) {
        if (this.obj != null) {
            w.print(this.obj.asVar());
            w.print(".");
        }
        w.print(this.method);
        w.print("(_cxt");
        for (JSExpr e : this.args) {
            w.print(", ");
            w.print(e.asVar());
        }
        w.print(")");
        if (this.returnType.equals("void")) {
            w.println(";");
        }
    }

    @Override
    public String asVar() {
        throw new RuntimeException("This should be wrapped in a JSLocal or JSThis");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        IExpr ai = jvm.argAsIs(this.obj);
        IExpr[] ais = new IExpr[this.args.length + 1];
        int ap = 0;
        ais[ap++] = jvm.cxt();
        for (JSExpr a : this.args) {
            ais[ap++] = jvm.arg(a);
        }
        IExpr mi = jvm.method().callInterface(this.returnType, ai, this.method, ais);
        jvm.local(this, mi);
    }
}

