/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.IVFWriter;
import org.flasck.flas.compiler.jsgen.form.IVForm;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSLocal;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSAssertion
implements IVForm {
    private final JSExpr obj;
    private final String meth;
    private final JSExpr[] args;

    public JSAssertion(JSExpr obj, String meth, JSExpr ... args) {
        this.obj = obj;
        this.meth = meth;
        this.args = args;
    }

    @Override
    public void write(IndentWriter w) {
        if (this.obj != null) {
            w.print(this.obj.asVar());
            w.print(".");
        }
        w.print(this.meth);
        w.print("(_cxt");
        for (JSExpr e : this.args) {
            w.print(", ");
            w.print(e.asVar());
        }
        w.println(");");
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        ArrayList<IExpr> as = new ArrayList<IExpr>();
        as.add(jvm.cxt());
        int ai = 0;
        for (JSExpr e : this.args) {
            if (("event".equals(this.meth) || "input".equals(this.meth) || "matchText".equals(this.meth) || "matchTitle".equals(this.meth) || "matchStyle".equals(this.meth) || "matchScroll".equals(this.meth) || "matchImageUri".equals(this.meth) || "matchHref".equals(this.meth)) && ai == 1) {
                as.add(jvm.argAs(e, new JavaType(List.class.getName())));
            } else if (("matchText".equals(this.meth) || "matchTitle".equals(this.meth) || "matchStyle".equals(this.meth) || "matchScroll".equals(this.meth)) && ai == 2) {
                as.add(jvm.argAs(e, JavaType.boolean_));
            } else if ("matchText".equals(this.meth) && ai == 3) {
                as.add(jvm.argAs(e, JavaType.boolean_));
            } else if (("matchTitle".equals(this.meth) || "matchStyle".equals(this.meth)) && ai == 3) {
                as.add(jvm.argAs(e, JavaType.string));
            } else if ("matchText".equals(this.meth) && ai == 4) {
                as.add(jvm.argAs(e, JavaType.string));
            } else if (("matchImageUri".equals(this.meth) || "matchHref".equals(this.meth)) && ai == 2) {
                as.add(jvm.argAs(e, JavaType.string));
            } else if ("matchScroll".equals(this.meth) && ai == 3) {
                as.add(jvm.argAs(e, new JavaType(Double.class.getName())));
            } else if ("shove".equals(this.meth) && ai == 1) {
                as.add(jvm.argAs(e, JavaType.string));
            } else {
                as.add(jvm.arg(e));
            }
            ++ai;
        }
        IExpr ret = jvm.method().callInterface("void", jvm.argAsIs(this.obj), this.meth, as.toArray(new IExpr[as.size()]));
        jvm.local(this, ret);
    }

    @Override
    public void asivm(IVFWriter iw) {
        switch (this.meth) {
            case "assertSameValue": {
                iw.println("assert same value");
                IVFWriter inner = iw.indent();
                for (JSExpr e : this.args) {
                    if (e instanceof JSLocal) {
                        inner.println(e.asVar());
                        continue;
                    }
                    inner.write(e);
                }
                break;
            }
            default: {
                iw.println("assertion " + this.meth);
                IVFWriter inner = iw.indent();
                for (JSExpr e : this.args) {
                    inner.write(e);
                }
            }
        }
    }

    @Override
    public String asVar() {
        return null;
    }
}

