/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.form;

import org.flasck.flas.compiler.jsgen.creators.JVMCreationContext;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.jvm.J;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.bytecode.mock.IndentWriter;

public class IsConstExpr
implements JSExpr {
    private final JSExpr var;
    private final Integer cnst;
    private final String str;

    public IsConstExpr(JSExpr var, int cnst) {
        this.var = var;
        this.cnst = cnst;
        this.str = null;
    }

    public IsConstExpr(JSExpr var, String str) {
        this.var = var;
        this.cnst = null;
        this.str = str;
    }

    @Override
    public String asVar() {
        return null;
    }

    @Override
    public void write(IndentWriter w) {
        if (this.cnst != null) {
            w.print("(" + this.var.asVar() + " == " + this.cnst + ")");
        } else {
            w.print("(" + this.var.asVar() + " == '" + this.str + "')");
        }
    }

    @Override
    public void generate(JVMCreationContext jvm) {
        NewMethodDefiner meth = jvm.method();
        IExpr myVar = jvm.arg(this.var);
        IExpr blk = this.cnst != null ? meth.callInterface(J.BOOLEANP.getActual(), jvm.cxt(), "isConst", new IExpr[]{myVar, meth.intConst(this.cnst.intValue())}) : meth.callInterface(J.BOOLEANP.getActual(), jvm.cxt(), "isConst", new IExpr[]{myVar, meth.stringConst(this.str)});
        jvm.local(this, blk);
    }
}

