/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.compiler.jsgen.creators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.UnitTestName;
import org.flasck.flas.compiler.jsgen.creators.BasicJVMCreationContext;
import org.flasck.flas.compiler.jsgen.creators.JSBlock;
import org.flasck.flas.compiler.jsgen.creators.JSMethodCreator;
import org.flasck.flas.compiler.jsgen.form.CacheSingleton;
import org.flasck.flas.compiler.jsgen.form.CheckCached;
import org.flasck.flas.compiler.jsgen.form.ClearRunner;
import org.flasck.flas.compiler.jsgen.form.GetCached;
import org.flasck.flas.compiler.jsgen.form.IVFWriter;
import org.flasck.flas.compiler.jsgen.form.InitContext;
import org.flasck.flas.compiler.jsgen.form.JSCopyContract;
import org.flasck.flas.compiler.jsgen.form.JSExpr;
import org.flasck.flas.compiler.jsgen.form.JSInheritFrom;
import org.flasck.flas.compiler.jsgen.form.JSLocal;
import org.flasck.flas.compiler.jsgen.form.JSVar;
import org.flasck.flas.compiler.jsgen.packaging.JSStorage;
import org.flasck.jvm.J;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.mock.IndentWriter;

public class JSMethod
extends JSBlock
implements JSMethodCreator {
    private final JSStorage jse;
    private final NameOfThing fnName;
    private final NameOfThing clzName;
    private final boolean prototype;
    private boolean isOptional;
    private final String name;
    final List<JSVar> args = new ArrayList<JSVar>();
    private int nextVar = 1;
    private boolean wantArgumentList = false;
    private String returnsA = J.OBJECT;
    public List<JSExpr> superArgs = new ArrayList<JSExpr>();
    private boolean hasHandler;
    private boolean genJS = true;
    private boolean genJVM = true;
    private JSExpr runner = null;

    public JSMethod(JSStorage jse, NameOfThing fnName, NameOfThing pkg, boolean prototype, String name) {
        this.jse = jse;
        this.fnName = fnName;
        this.clzName = pkg;
        this.prototype = prototype;
        this.name = name;
    }

    public String getPackage() {
        return this.clzName.jsName();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void noJS() {
        this.genJS = false;
    }

    @Override
    public void noJVM() {
        this.genJVM = false;
    }

    @Override
    public void makeOptional() {
        this.isOptional = true;
    }

    @Override
    public String jsName() {
        if (this.name == null) {
            return this.clzName.jsName();
        }
        return this.clzName.jsName() + "." + this.name;
    }

    @Override
    public void argumentList() {
        this.wantArgumentList = true;
    }

    @Override
    public JSVar argument(String type, String name) {
        JSVar ret = new JSVar(type, name);
        this.args.add(ret);
        return ret;
    }

    @Override
    public JSVar argument(String name) {
        JSVar ret = new JSVar(name);
        this.args.add(ret);
        return ret;
    }

    @Override
    public JSVar handlerArg() {
        this.hasHandler = true;
        return this.argument("_ih");
    }

    @Override
    public void returnsType(String ty) {
        this.returnsA = ty;
    }

    @Override
    public void helper(JSExpr runner) {
        this.runner = runner;
    }

    @Override
    public void superArg(JSExpr a) {
        this.superArgs.add(a);
    }

    public void inheritFrom(NameOfThing baseClass) {
        this.stmts.add(new JSInheritFrom(this, baseClass));
    }

    @Override
    public void clear() {
        this.stmts.add(new ClearRunner());
    }

    @Override
    public void checkCached() {
        JSLocal stmt = new JSLocal(this, new GetCached(this.fnName.uniqueName()));
        this.stmts.add(stmt);
        this.stmts.add(new CheckCached(stmt));
    }

    @Override
    public void cacheResult(JSExpr r) {
        this.stmts.add(new CacheSingleton(this.fnName.uniqueName(), r));
    }

    @Override
    public void initContext(boolean field) {
        this.stmts.add(new InitContext(this.jse, field));
    }

    @Override
    public void copyContract(JSExpr copyInto, String fld, String arg) {
        this.stmts.add(new JSCopyContract(copyInto, fld, arg));
    }

    @Override
    public void write(IndentWriter w, Set<NameOfThing> names, Set<String> exports) {
        if (!this.genJS) {
            return;
        }
        w.println("");
        if (this.fnName != null && this.fnName instanceof FunctionName) {
            FunctionName fn = (FunctionName)this.fnName;
            JSMethod.ensureContainingNames(w, fn.container(), names);
            if (fn.packageName().uniqueName() == null) {
                w.print("var ");
                exports.add(fn.jsPName());
            }
            w.print(fn.jsPName());
        } else {
            if (this.name == null && (this.clzName.packageName().uniqueName() == null || this.clzName.baseName().startsWith("_st"))) {
                w.print("var ");
                exports.add(this.clzName.jsName());
            }
            w.print(this.clzName.jsName());
            if (this.name != null) {
                w.print(".");
                if (this.prototype) {
                    w.print("prototype.");
                }
                w.print(this.name);
            }
        }
        w.print(" = function");
        w.print("(");
        boolean isFirst = true;
        for (JSVar v : this.args) {
            if (isFirst) {
                isFirst = false;
            } else {
                w.print(", ");
            }
            w.print(v.asVar());
        }
        w.print(") ");
        super.write(w);
        w.println("");
        if (this.name != null) {
            w.println("");
            if (this.fnName != null && this.fnName instanceof FunctionName) {
                w.print(((FunctionName)this.fnName).jsPName());
            } else {
                w.print(this.clzName.jsName());
                w.print(".");
                if (this.prototype) {
                    w.print("prototype.");
                }
                w.print(this.name);
            }
            w.print(".nfargs = function() { return ");
            w.print(Integer.toString(this.args.size() - (this.hasHandler ? 2 : 1)));
            w.println("; }");
        }
    }

    static void ensureContainingNames(IndentWriter w, NameOfThing container, Set<NameOfThing> curr) {
        if (container != null && !curr.contains(container)) {
            JSMethod.ensureContainingNames(w, container.container(), curr);
            if (container instanceof FunctionName) {
                String full = ((FunctionName)container).jsPName();
                w.print("if (typeof(");
                w.print(full);
                w.print(") === 'undefined') ");
                w.print(full);
                w.println(" = {};");
                w.println("");
            }
            curr.add(container);
        }
    }

    public void generate(ByteCodeEnvironment bce, boolean isInterface) {
        if (bce != null && this.genJVM) {
            BasicJVMCreationContext jvm = this.fnName instanceof UnitTestName ? new BasicJVMCreationContext(bce, (UnitTestName)this.fnName, this.args) : (this.fnName == null && this.name == null ? new BasicJVMCreationContext(bce, this.clzName, this.args, this.superArgs) : (this.prototype ? new BasicJVMCreationContext(bce, this.clzName, this.name, this.fnName, this.wantArgumentList, this.args, this.runner, this.returnsA) : new BasicJVMCreationContext(bce, this.clzName, this.name, this.fnName, this.wantArgumentList, this.args, this.runner, this.returnsA, null)));
            if (!isInterface || this.isOptional) {
                if (this.isOptional) {
                    jvm.version(55);
                }
                super.generate(jvm);
                jvm.done(this);
            }
        }
    }

    public String asivm() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        IVFWriter iw = new IVFWriter(pw);
        this.asivm(iw);
        return sw.toString();
    }

    @Override
    public void asivm(IVFWriter iw) {
        if (this.name == null) {
            iw.println("ctor");
        } else {
            iw.println("method " + this.name);
        }
        super.asivm(iw);
    }

    public String obtainNextVar() {
        return "_v" + this.nextVar++;
    }

    public String toString() {
        return "method " + this.name;
    }
}

